<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DamageWaiverOptionType StructType
 * @subpackage Structs
 */
class DamageWaiverOptionType extends AbstractStructBase
{
    /**
     * The ChargeTemplateID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ChargeTemplateID;
    /**
     * The Coverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Coverage
     */
    public $Coverage;
    /**
     * Constructor method for DamageWaiverOptionType
     * @uses DamageWaiverOptionType::setChargeTemplateID()
     * @uses DamageWaiverOptionType::setCoverage()
     * @param int $chargeTemplateID
     * @param \StructType\Coverage $coverage
     */
    public function __construct($chargeTemplateID = null, \StructType\Coverage $coverage = null)
    {
        $this
            ->setChargeTemplateID($chargeTemplateID)
            ->setCoverage($coverage);
    }
    /**
     * Get ChargeTemplateID value
     * @return int
     */
    public function getChargeTemplateID()
    {
        return $this->ChargeTemplateID;
    }
    /**
     * Set ChargeTemplateID value
     * @param int $chargeTemplateID
     * @return \StructType\DamageWaiverOptionType
     */
    public function setChargeTemplateID($chargeTemplateID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeTemplateID) && !(is_int($chargeTemplateID) || ctype_digit($chargeTemplateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeTemplateID, true), gettype($chargeTemplateID)), __LINE__);
        }
        $this->ChargeTemplateID = $chargeTemplateID;
        return $this;
    }
    /**
     * Get Coverage value
     * @return \StructType\Coverage|null
     */
    public function getCoverage()
    {
        return $this->Coverage;
    }
    /**
     * Set Coverage value
     * @param \StructType\Coverage $coverage
     * @return \StructType\DamageWaiverOptionType
     */
    public function setCoverage(\StructType\Coverage $coverage = null)
    {
        $this->Coverage = $coverage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DamageWaiverOptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
