<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAcctType StructType
 * @subpackage Structs
 */
class BankAcctType extends AbstractStructBase
{
    /**
     * The BankAcctName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAcctName;
    /**
     * The AcctHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcctHolderName;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The BankID
     * @var string
     */
    public $BankID;
    /**
     * The AcctType
     * @var string
     */
    public $AcctType;
    /**
     * The BankAcctNumber
     * @var string
     */
    public $BankAcctNumber;
    /**
     * The ChecksAcceptedInd
     * @var bool
     */
    public $ChecksAcceptedInd;
    /**
     * The AcctNumberToken
     * @var string
     */
    public $AcctNumberToken;
    /**
     * The MaskedAcctNumber
     * @var string
     */
    public $MaskedAcctNumber;
    /**
     * The RoutingNumberToken
     * @var string
     */
    public $RoutingNumberToken;
    /**
     * The MaskedRoutingNumber
     * @var string
     */
    public $MaskedRoutingNumber;
    /**
     * Constructor method for BankAcctType
     * @uses BankAcctType::setBankAcctName()
     * @uses BankAcctType::setAcctHolderName()
     * @uses BankAcctType::setAddress()
     * @uses BankAcctType::setShareSynchInd()
     * @uses BankAcctType::setShareMarketInd()
     * @uses BankAcctType::setBankID()
     * @uses BankAcctType::setAcctType()
     * @uses BankAcctType::setBankAcctNumber()
     * @uses BankAcctType::setChecksAcceptedInd()
     * @uses BankAcctType::setAcctNumberToken()
     * @uses BankAcctType::setMaskedAcctNumber()
     * @uses BankAcctType::setRoutingNumberToken()
     * @uses BankAcctType::setMaskedRoutingNumber()
     * @param string $bankAcctName
     * @param string $acctHolderName
     * @param \StructType\AddressType $address
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $bankID
     * @param string $acctType
     * @param string $bankAcctNumber
     * @param bool $checksAcceptedInd
     * @param string $acctNumberToken
     * @param string $maskedAcctNumber
     * @param string $routingNumberToken
     * @param string $maskedRoutingNumber
     */
    public function __construct($bankAcctName = null, $acctHolderName = null, \StructType\AddressType $address = null, $shareSynchInd = null, $shareMarketInd = null, $bankID = null, $acctType = null, $bankAcctNumber = null, $checksAcceptedInd = null, $acctNumberToken = null, $maskedAcctNumber = null, $routingNumberToken = null, $maskedRoutingNumber = null)
    {
        $this
            ->setBankAcctName($bankAcctName)
            ->setAcctHolderName($acctHolderName)
            ->setAddress($address)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setBankID($bankID)
            ->setAcctType($acctType)
            ->setBankAcctNumber($bankAcctNumber)
            ->setChecksAcceptedInd($checksAcceptedInd)
            ->setAcctNumberToken($acctNumberToken)
            ->setMaskedAcctNumber($maskedAcctNumber)
            ->setRoutingNumberToken($routingNumberToken)
            ->setMaskedRoutingNumber($maskedRoutingNumber);
    }
    /**
     * Get BankAcctName value
     * @return string|null
     */
    public function getBankAcctName()
    {
        return $this->BankAcctName;
    }
    /**
     * Set BankAcctName value
     * @param string $bankAcctName
     * @return \StructType\BankAcctType
     */
    public function setBankAcctName($bankAcctName = null)
    {
        // validation for constraint: string
        if (!is_null($bankAcctName) && !is_string($bankAcctName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAcctName, true), gettype($bankAcctName)), __LINE__);
        }
        $this->BankAcctName = $bankAcctName;
        return $this;
    }
    /**
     * Get AcctHolderName value
     * @return string|null
     */
    public function getAcctHolderName()
    {
        return $this->AcctHolderName;
    }
    /**
     * Set AcctHolderName value
     * @param string $acctHolderName
     * @return \StructType\BankAcctType
     */
    public function setAcctHolderName($acctHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($acctHolderName) && !is_string($acctHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctHolderName, true), gettype($acctHolderName)), __LINE__);
        }
        $this->AcctHolderName = $acctHolderName;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\BankAcctType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\BankAcctType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\BankAcctType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \StructType\BankAcctType
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankID, true), gettype($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
    /**
     * Get AcctType value
     * @return string|null
     */
    public function getAcctType()
    {
        return $this->AcctType;
    }
    /**
     * Set AcctType value
     * @param string $acctType
     * @return \StructType\BankAcctType
     */
    public function setAcctType($acctType = null)
    {
        // validation for constraint: string
        if (!is_null($acctType) && !is_string($acctType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctType, true), gettype($acctType)), __LINE__);
        }
        $this->AcctType = $acctType;
        return $this;
    }
    /**
     * Get BankAcctNumber value
     * @return string|null
     */
    public function getBankAcctNumber()
    {
        return $this->BankAcctNumber;
    }
    /**
     * Set BankAcctNumber value
     * @param string $bankAcctNumber
     * @return \StructType\BankAcctType
     */
    public function setBankAcctNumber($bankAcctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAcctNumber) && !is_string($bankAcctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAcctNumber, true), gettype($bankAcctNumber)), __LINE__);
        }
        $this->BankAcctNumber = $bankAcctNumber;
        return $this;
    }
    /**
     * Get ChecksAcceptedInd value
     * @return bool|null
     */
    public function getChecksAcceptedInd()
    {
        return $this->ChecksAcceptedInd;
    }
    /**
     * Set ChecksAcceptedInd value
     * @param bool $checksAcceptedInd
     * @return \StructType\BankAcctType
     */
    public function setChecksAcceptedInd($checksAcceptedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($checksAcceptedInd) && !is_bool($checksAcceptedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checksAcceptedInd, true), gettype($checksAcceptedInd)), __LINE__);
        }
        $this->ChecksAcceptedInd = $checksAcceptedInd;
        return $this;
    }
    /**
     * Get AcctNumberToken value
     * @return string|null
     */
    public function getAcctNumberToken()
    {
        return $this->AcctNumberToken;
    }
    /**
     * Set AcctNumberToken value
     * @param string $acctNumberToken
     * @return \StructType\BankAcctType
     */
    public function setAcctNumberToken($acctNumberToken = null)
    {
        // validation for constraint: string
        if (!is_null($acctNumberToken) && !is_string($acctNumberToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctNumberToken, true), gettype($acctNumberToken)), __LINE__);
        }
        $this->AcctNumberToken = $acctNumberToken;
        return $this;
    }
    /**
     * Get MaskedAcctNumber value
     * @return string|null
     */
    public function getMaskedAcctNumber()
    {
        return $this->MaskedAcctNumber;
    }
    /**
     * Set MaskedAcctNumber value
     * @param string $maskedAcctNumber
     * @return \StructType\BankAcctType
     */
    public function setMaskedAcctNumber($maskedAcctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedAcctNumber) && !is_string($maskedAcctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedAcctNumber, true), gettype($maskedAcctNumber)), __LINE__);
        }
        $this->MaskedAcctNumber = $maskedAcctNumber;
        return $this;
    }
    /**
     * Get RoutingNumberToken value
     * @return string|null
     */
    public function getRoutingNumberToken()
    {
        return $this->RoutingNumberToken;
    }
    /**
     * Set RoutingNumberToken value
     * @param string $routingNumberToken
     * @return \StructType\BankAcctType
     */
    public function setRoutingNumberToken($routingNumberToken = null)
    {
        // validation for constraint: string
        if (!is_null($routingNumberToken) && !is_string($routingNumberToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingNumberToken, true), gettype($routingNumberToken)), __LINE__);
        }
        $this->RoutingNumberToken = $routingNumberToken;
        return $this;
    }
    /**
     * Get MaskedRoutingNumber value
     * @return string|null
     */
    public function getMaskedRoutingNumber()
    {
        return $this->MaskedRoutingNumber;
    }
    /**
     * Set MaskedRoutingNumber value
     * @param string $maskedRoutingNumber
     * @return \StructType\BankAcctType
     */
    public function setMaskedRoutingNumber($maskedRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedRoutingNumber) && !is_string($maskedRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedRoutingNumber, true), gettype($maskedRoutingNumber)), __LINE__);
        }
        $this->MaskedRoutingNumber = $maskedRoutingNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAcctType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
