<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Areas StructType
 * @subpackage Structs
 */
class Areas extends AbstractStructBase
{
    /**
     * The Area
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchAreaType[]
     */
    public $Area;
    /**
     * The PlaceHolder
     * @var int
     */
    public $PlaceHolder;
    /**
     * Constructor method for Areas
     * @uses Areas::setArea()
     * @uses Areas::setPlaceHolder()
     * @param \StructType\SearchAreaType[] $area
     * @param int $placeHolder
     */
    public function __construct(array $area = array(), $placeHolder = null)
    {
        $this
            ->setArea($area)
            ->setPlaceHolder($placeHolder);
    }
    /**
     * Get Area value
     * @return \StructType\SearchAreaType[]|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * This method is responsible for validating the values passed to the setArea method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArea method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAreaForArrayConstraintsFromSetArea(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $areasAreaItem) {
            // validation for constraint: itemType
            if (!$areasAreaItem instanceof \StructType\SearchAreaType) {
                $invalidValues[] = is_object($areasAreaItem) ? get_class($areasAreaItem) : sprintf('%s(%s)', gettype($areasAreaItem), var_export($areasAreaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Area property can only contain items of type \StructType\SearchAreaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Area value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchAreaType[] $area
     * @return \StructType\Areas
     */
    public function setArea(array $area = array())
    {
        // validation for constraint: array
        if ('' !== ($areaArrayErrorMessage = self::validateAreaForArrayConstraintsFromSetArea($area))) {
            throw new \InvalidArgumentException($areaArrayErrorMessage, __LINE__);
        }
        $this->Area = $area;
        return $this;
    }
    /**
     * Add item to Area value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchAreaType $item
     * @return \StructType\Areas
     */
    public function addToArea(\StructType\SearchAreaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchAreaType) {
            throw new \InvalidArgumentException(sprintf('The Area property can only contain items of type \StructType\SearchAreaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Area[] = $item;
        return $this;
    }
    /**
     * Get PlaceHolder value
     * @return int|null
     */
    public function getPlaceHolder()
    {
        return $this->PlaceHolder;
    }
    /**
     * Set PlaceHolder value
     * @param int $placeHolder
     * @return \StructType\Areas
     */
    public function setPlaceHolder($placeHolder = null)
    {
        // validation for constraint: int
        if (!is_null($placeHolder) && !(is_int($placeHolder) || ctype_digit($placeHolder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($placeHolder, true), gettype($placeHolder)), __LINE__);
        }
        $this->PlaceHolder = $placeHolder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Areas
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
