<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://paiement.systempay.fr/vads-ws/v5?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://paiement.systempay.fr/vads-ws/v5?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelCapturedPayment operation/method
 */
if ($cancel->cancelCapturedPayment(new \StructType\CancelCapturedPayment()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for cancelPayment operation/method
 */
if ($cancel->cancelPayment(new \StructType\CancelPayment()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for cancelRefund operation/method
 */
if ($cancel->cancelRefund(new \StructType\CancelRefund()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for cancelSubscription operation/method
 */
if ($cancel->cancelSubscription(new \StructType\CancelSubscription()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for cancelToken operation/method
 */
if ($cancel->cancelToken(new \StructType\CancelToken()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Capture ServiceType
 */
$capture = new \ServiceType\Capture($options);
/**
 * Sample call for capturePayment operation/method
 */
if ($capture->capturePayment(new \StructType\CapturePayment()) !== false) {
    print_r($capture->getResult());
} else {
    print_r($capture->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createTokenByIban operation/method
 */
if ($create->createTokenByIban(new \StructType\CreateTokenByIban()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createTokenFromTransaction operation/method
 */
if ($create->createTokenFromTransaction(new \StructType\CreateTokenFromTransaction()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPayment operation/method
 */
if ($create->createPayment(new \StructType\CreatePayment()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createSubscription operation/method
 */
if ($create->createSubscription(new \StructType\CreateSubscription()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createToken operation/method
 */
if ($create->createToken(new \StructType\CreateToken()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Reactivate ServiceType
 */
$reactivate = new \ServiceType\Reactivate($options);
/**
 * Sample call for reactivateToken operation/method
 */
if ($reactivate->reactivateToken(new \StructType\ReactivateToken()) !== false) {
    print_r($reactivate->getResult());
} else {
    print_r($reactivate->getLastError());
}
/**
 * Samples for Duplicate ServiceType
 */
$duplicate = new \ServiceType\Duplicate($options);
/**
 * Sample call for duplicatePayment operation/method
 */
if ($duplicate->duplicatePayment(new \StructType\DuplicatePayment()) !== false) {
    print_r($duplicate->getResult());
} else {
    print_r($duplicate->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkThreeDSAuthentication operation/method
 */
if ($check->checkThreeDSAuthentication(new \StructType\CheckThreeDSAuthentication()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updatePayment operation/method
 */
if ($update->updatePayment(new \StructType\UpdatePayment()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePaymentDetails operation/method
 */
if ($update->updatePaymentDetails(new \StructType\UpdatePaymentDetails()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateToken operation/method
 */
if ($update->updateToken(new \StructType\UpdateToken()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRefund operation/method
 */
if ($update->updateRefund(new \StructType\UpdateRefund()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSubscription operation/method
 */
if ($update->updateSubscription(new \StructType\UpdateSubscription()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getPaymentDetails operation/method
 */
if ($get->getPaymentDetails(new \StructType\GetPaymentDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPaymentUuid operation/method
 */
if ($get->getPaymentUuid(new \StructType\GetPaymentUuid()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSubscriptionDetails operation/method
 */
if ($get->getSubscriptionDetails(new \StructType\GetSubscriptionDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTokenDetails operation/method
 */
if ($get->getTokenDetails(new \StructType\GetTokenDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Refund ServiceType
 */
$refund = new \ServiceType\Refund($options);
/**
 * Sample call for refundPayment operation/method
 */
if ($refund->refundPayment(new \StructType\RefundPayment()) !== false) {
    print_r($refund->getResult());
} else {
    print_r($refund->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ServiceType\Verify($options);
/**
 * Sample call for verifyThreeDSEnrollment operation/method
 */
if ($verify->verifyThreeDSEnrollment(new \StructType\VerifyThreeDSEnrollment()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for validatePayment operation/method
 */
if ($validate->validatePayment(new \StructType\ValidatePayment()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for findPayments operation/method
 */
if ($find->findPayments(new \StructType\FindPayments()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
