<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for techRequest StructType
 * @subpackage Structs
 */
class TechRequest extends AbstractStructBase
{
    /**
     * The browserUserAgent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $browserUserAgent;
    /**
     * The browserAccept
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $browserAccept;
    /**
     * The integrationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $integrationType;
    /**
     * Constructor method for techRequest
     * @uses TechRequest::setBrowserUserAgent()
     * @uses TechRequest::setBrowserAccept()
     * @uses TechRequest::setIntegrationType()
     * @param string $browserUserAgent
     * @param string $browserAccept
     * @param string $integrationType
     */
    public function __construct($browserUserAgent = null, $browserAccept = null, $integrationType = null)
    {
        $this
            ->setBrowserUserAgent($browserUserAgent)
            ->setBrowserAccept($browserAccept)
            ->setIntegrationType($integrationType);
    }
    /**
     * Get browserUserAgent value
     * @return string|null
     */
    public function getBrowserUserAgent()
    {
        return $this->browserUserAgent;
    }
    /**
     * Set browserUserAgent value
     * @param string $browserUserAgent
     * @return \StructType\TechRequest
     */
    public function setBrowserUserAgent($browserUserAgent = null)
    {
        // validation for constraint: string
        if (!is_null($browserUserAgent) && !is_string($browserUserAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserUserAgent, true), gettype($browserUserAgent)), __LINE__);
        }
        $this->browserUserAgent = $browserUserAgent;
        return $this;
    }
    /**
     * Get browserAccept value
     * @return string|null
     */
    public function getBrowserAccept()
    {
        return $this->browserAccept;
    }
    /**
     * Set browserAccept value
     * @param string $browserAccept
     * @return \StructType\TechRequest
     */
    public function setBrowserAccept($browserAccept = null)
    {
        // validation for constraint: string
        if (!is_null($browserAccept) && !is_string($browserAccept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browserAccept, true), gettype($browserAccept)), __LINE__);
        }
        $this->browserAccept = $browserAccept;
        return $this;
    }
    /**
     * Get integrationType value
     * @return string|null
     */
    public function getIntegrationType()
    {
        return $this->integrationType;
    }
    /**
     * Set integrationType value
     * @param string $integrationType
     * @return \StructType\TechRequest
     */
    public function setIntegrationType($integrationType = null)
    {
        // validation for constraint: string
        if (!is_null($integrationType) && !is_string($integrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationType, true), gettype($integrationType)), __LINE__);
        }
        $this->integrationType = $integrationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TechRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
