<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartRequest StructType
 * @subpackage Structs
 */
class ShoppingCartRequest extends AbstractStructBase
{
    /**
     * The insuranceAmount
     * @var int
     */
    public $insuranceAmount;
    /**
     * The shippingAmount
     * @var int
     */
    public $shippingAmount;
    /**
     * The taxAmount
     * @var int
     */
    public $taxAmount;
    /**
     * The cartItemInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CartItemInfo[]
     */
    public $cartItemInfo;
    /**
     * Constructor method for shoppingCartRequest
     * @uses ShoppingCartRequest::setInsuranceAmount()
     * @uses ShoppingCartRequest::setShippingAmount()
     * @uses ShoppingCartRequest::setTaxAmount()
     * @uses ShoppingCartRequest::setCartItemInfo()
     * @param int $insuranceAmount
     * @param int $shippingAmount
     * @param int $taxAmount
     * @param \StructType\CartItemInfo[] $cartItemInfo
     */
    public function __construct($insuranceAmount = null, $shippingAmount = null, $taxAmount = null, array $cartItemInfo = array())
    {
        $this
            ->setInsuranceAmount($insuranceAmount)
            ->setShippingAmount($shippingAmount)
            ->setTaxAmount($taxAmount)
            ->setCartItemInfo($cartItemInfo);
    }
    /**
     * Get insuranceAmount value
     * @return int|null
     */
    public function getInsuranceAmount()
    {
        return $this->insuranceAmount;
    }
    /**
     * Set insuranceAmount value
     * @param int $insuranceAmount
     * @return \StructType\ShoppingCartRequest
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: int
        if (!is_null($insuranceAmount) && !(is_int($insuranceAmount) || ctype_digit($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->insuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get shippingAmount value
     * @return int|null
     */
    public function getShippingAmount()
    {
        return $this->shippingAmount;
    }
    /**
     * Set shippingAmount value
     * @param int $shippingAmount
     * @return \StructType\ShoppingCartRequest
     */
    public function setShippingAmount($shippingAmount = null)
    {
        // validation for constraint: int
        if (!is_null($shippingAmount) && !(is_int($shippingAmount) || ctype_digit($shippingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingAmount, true), gettype($shippingAmount)), __LINE__);
        }
        $this->shippingAmount = $shippingAmount;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return int|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param int $taxAmount
     * @return \StructType\ShoppingCartRequest
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: int
        if (!is_null($taxAmount) && !(is_int($taxAmount) || ctype_digit($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get cartItemInfo value
     * @return \StructType\CartItemInfo[]|null
     */
    public function getCartItemInfo()
    {
        return $this->cartItemInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCartItemInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCartItemInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCartItemInfoForArrayConstraintsFromSetCartItemInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingCartRequestCartItemInfoItem) {
            // validation for constraint: itemType
            if (!$shoppingCartRequestCartItemInfoItem instanceof \StructType\CartItemInfo) {
                $invalidValues[] = is_object($shoppingCartRequestCartItemInfoItem) ? get_class($shoppingCartRequestCartItemInfoItem) : sprintf('%s(%s)', gettype($shoppingCartRequestCartItemInfoItem), var_export($shoppingCartRequestCartItemInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cartItemInfo property can only contain items of type \StructType\CartItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cartItemInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CartItemInfo[] $cartItemInfo
     * @return \StructType\ShoppingCartRequest
     */
    public function setCartItemInfo(array $cartItemInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($cartItemInfoArrayErrorMessage = self::validateCartItemInfoForArrayConstraintsFromSetCartItemInfo($cartItemInfo))) {
            throw new \InvalidArgumentException($cartItemInfoArrayErrorMessage, __LINE__);
        }
        $this->cartItemInfo = $cartItemInfo;
        return $this;
    }
    /**
     * Add item to cartItemInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CartItemInfo $item
     * @return \StructType\ShoppingCartRequest
     */
    public function addToCartItemInfo(\StructType\CartItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CartItemInfo) {
            throw new \InvalidArgumentException(sprintf('The cartItemInfo property can only contain items of type \StructType\CartItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cartItemInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingCartRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
