<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentResponse StructType
 * @subpackage Structs
 */
class PaymentResponse extends AbstractStructBase
{
    /**
     * The transactionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionId;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amount;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $currency;
    /**
     * The effectiveAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $effectiveAmount;
    /**
     * The effectiveCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $effectiveCurrency;
    /**
     * The expectedCaptureDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedCaptureDate;
    /**
     * The manualValidation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manualValidation;
    /**
     * The operationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationType;
    /**
     * The creationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $creationDate;
    /**
     * The externalTransactionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalTransactionId;
    /**
     * The liabilityShift
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $liabilityShift;
    /**
     * The transactionUuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionUuid;
    /**
     * The sequenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sequenceNumber;
    /**
     * The paymentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentType;
    /**
     * The nsu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nsu;
    /**
     * The paymentError
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $paymentError;
    /**
     * The wallet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wallet;
    /**
     * The preTaxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $preTaxAmount;
    /**
     * The taxRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxRate;
    /**
     * The taxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $taxAmount;
    /**
     * Constructor method for paymentResponse
     * @uses PaymentResponse::setTransactionId()
     * @uses PaymentResponse::setAmount()
     * @uses PaymentResponse::setCurrency()
     * @uses PaymentResponse::setEffectiveAmount()
     * @uses PaymentResponse::setEffectiveCurrency()
     * @uses PaymentResponse::setExpectedCaptureDate()
     * @uses PaymentResponse::setManualValidation()
     * @uses PaymentResponse::setOperationType()
     * @uses PaymentResponse::setCreationDate()
     * @uses PaymentResponse::setExternalTransactionId()
     * @uses PaymentResponse::setLiabilityShift()
     * @uses PaymentResponse::setTransactionUuid()
     * @uses PaymentResponse::setSequenceNumber()
     * @uses PaymentResponse::setPaymentType()
     * @uses PaymentResponse::setNsu()
     * @uses PaymentResponse::setPaymentError()
     * @uses PaymentResponse::setWallet()
     * @uses PaymentResponse::setPreTaxAmount()
     * @uses PaymentResponse::setTaxRate()
     * @uses PaymentResponse::setTaxAmount()
     * @param string $transactionId
     * @param int $amount
     * @param int $currency
     * @param int $effectiveAmount
     * @param int $effectiveCurrency
     * @param string $expectedCaptureDate
     * @param int $manualValidation
     * @param int $operationType
     * @param string $creationDate
     * @param string $externalTransactionId
     * @param string $liabilityShift
     * @param string $transactionUuid
     * @param int $sequenceNumber
     * @param string $paymentType
     * @param string $nsu
     * @param int $paymentError
     * @param string $wallet
     * @param int $preTaxAmount
     * @param string $taxRate
     * @param int $taxAmount
     */
    public function __construct($transactionId = null, $amount = null, $currency = null, $effectiveAmount = null, $effectiveCurrency = null, $expectedCaptureDate = null, $manualValidation = null, $operationType = null, $creationDate = null, $externalTransactionId = null, $liabilityShift = null, $transactionUuid = null, $sequenceNumber = null, $paymentType = null, $nsu = null, $paymentError = null, $wallet = null, $preTaxAmount = null, $taxRate = null, $taxAmount = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setEffectiveAmount($effectiveAmount)
            ->setEffectiveCurrency($effectiveCurrency)
            ->setExpectedCaptureDate($expectedCaptureDate)
            ->setManualValidation($manualValidation)
            ->setOperationType($operationType)
            ->setCreationDate($creationDate)
            ->setExternalTransactionId($externalTransactionId)
            ->setLiabilityShift($liabilityShift)
            ->setTransactionUuid($transactionUuid)
            ->setSequenceNumber($sequenceNumber)
            ->setPaymentType($paymentType)
            ->setNsu($nsu)
            ->setPaymentError($paymentError)
            ->setWallet($wallet)
            ->setPreTaxAmount($preTaxAmount)
            ->setTaxRate($taxRate)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get transactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param string $transactionId
     * @return \StructType\PaymentResponse
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\PaymentResponse
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return int|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param int $currency
     * @return \StructType\PaymentResponse
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: int
        if (!is_null($currency) && !(is_int($currency) || ctype_digit($currency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get effectiveAmount value
     * @return int|null
     */
    public function getEffectiveAmount()
    {
        return $this->effectiveAmount;
    }
    /**
     * Set effectiveAmount value
     * @param int $effectiveAmount
     * @return \StructType\PaymentResponse
     */
    public function setEffectiveAmount($effectiveAmount = null)
    {
        // validation for constraint: int
        if (!is_null($effectiveAmount) && !(is_int($effectiveAmount) || ctype_digit($effectiveAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($effectiveAmount, true), gettype($effectiveAmount)), __LINE__);
        }
        $this->effectiveAmount = $effectiveAmount;
        return $this;
    }
    /**
     * Get effectiveCurrency value
     * @return int|null
     */
    public function getEffectiveCurrency()
    {
        return $this->effectiveCurrency;
    }
    /**
     * Set effectiveCurrency value
     * @param int $effectiveCurrency
     * @return \StructType\PaymentResponse
     */
    public function setEffectiveCurrency($effectiveCurrency = null)
    {
        // validation for constraint: int
        if (!is_null($effectiveCurrency) && !(is_int($effectiveCurrency) || ctype_digit($effectiveCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($effectiveCurrency, true), gettype($effectiveCurrency)), __LINE__);
        }
        $this->effectiveCurrency = $effectiveCurrency;
        return $this;
    }
    /**
     * Get expectedCaptureDate value
     * @return string|null
     */
    public function getExpectedCaptureDate()
    {
        return $this->expectedCaptureDate;
    }
    /**
     * Set expectedCaptureDate value
     * @param string $expectedCaptureDate
     * @return \StructType\PaymentResponse
     */
    public function setExpectedCaptureDate($expectedCaptureDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedCaptureDate) && !is_string($expectedCaptureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedCaptureDate, true), gettype($expectedCaptureDate)), __LINE__);
        }
        $this->expectedCaptureDate = $expectedCaptureDate;
        return $this;
    }
    /**
     * Get manualValidation value
     * @return int|null
     */
    public function getManualValidation()
    {
        return $this->manualValidation;
    }
    /**
     * Set manualValidation value
     * @param int $manualValidation
     * @return \StructType\PaymentResponse
     */
    public function setManualValidation($manualValidation = null)
    {
        // validation for constraint: int
        if (!is_null($manualValidation) && !(is_int($manualValidation) || ctype_digit($manualValidation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manualValidation, true), gettype($manualValidation)), __LINE__);
        }
        $this->manualValidation = $manualValidation;
        return $this;
    }
    /**
     * Get operationType value
     * @return int|null
     */
    public function getOperationType()
    {
        return $this->operationType;
    }
    /**
     * Set operationType value
     * @param int $operationType
     * @return \StructType\PaymentResponse
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: int
        if (!is_null($operationType) && !(is_int($operationType) || ctype_digit($operationType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationType, true), gettype($operationType)), __LINE__);
        }
        $this->operationType = $operationType;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\PaymentResponse
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get externalTransactionId value
     * @return string|null
     */
    public function getExternalTransactionId()
    {
        return $this->externalTransactionId;
    }
    /**
     * Set externalTransactionId value
     * @param string $externalTransactionId
     * @return \StructType\PaymentResponse
     */
    public function setExternalTransactionId($externalTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($externalTransactionId) && !is_string($externalTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTransactionId, true), gettype($externalTransactionId)), __LINE__);
        }
        $this->externalTransactionId = $externalTransactionId;
        return $this;
    }
    /**
     * Get liabilityShift value
     * @return string|null
     */
    public function getLiabilityShift()
    {
        return $this->liabilityShift;
    }
    /**
     * Set liabilityShift value
     * @param string $liabilityShift
     * @return \StructType\PaymentResponse
     */
    public function setLiabilityShift($liabilityShift = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityShift) && !is_string($liabilityShift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityShift, true), gettype($liabilityShift)), __LINE__);
        }
        $this->liabilityShift = $liabilityShift;
        return $this;
    }
    /**
     * Get transactionUuid value
     * @return string|null
     */
    public function getTransactionUuid()
    {
        return $this->transactionUuid;
    }
    /**
     * Set transactionUuid value
     * @param string $transactionUuid
     * @return \StructType\PaymentResponse
     */
    public function setTransactionUuid($transactionUuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionUuid) && !is_string($transactionUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionUuid, true), gettype($transactionUuid)), __LINE__);
        }
        $this->transactionUuid = $transactionUuid;
        return $this;
    }
    /**
     * Get sequenceNumber value
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param int $sequenceNumber
     * @return \StructType\PaymentResponse
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !(is_int($sequenceNumber) || ctype_digit($sequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get paymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @uses \EnumType\PaymentType::valueIsValid()
     * @uses \EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \StructType\PaymentResponse
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentType', is_array($paymentType) ? implode(', ', $paymentType) : var_export($paymentType, true), implode(', ', \EnumType\PaymentType::getValidValues())), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get nsu value
     * @return string|null
     */
    public function getNsu()
    {
        return $this->nsu;
    }
    /**
     * Set nsu value
     * @param string $nsu
     * @return \StructType\PaymentResponse
     */
    public function setNsu($nsu = null)
    {
        // validation for constraint: string
        if (!is_null($nsu) && !is_string($nsu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nsu, true), gettype($nsu)), __LINE__);
        }
        $this->nsu = $nsu;
        return $this;
    }
    /**
     * Get paymentError value
     * @return int|null
     */
    public function getPaymentError()
    {
        return $this->paymentError;
    }
    /**
     * Set paymentError value
     * @param int $paymentError
     * @return \StructType\PaymentResponse
     */
    public function setPaymentError($paymentError = null)
    {
        // validation for constraint: int
        if (!is_null($paymentError) && !(is_int($paymentError) || ctype_digit($paymentError))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentError, true), gettype($paymentError)), __LINE__);
        }
        $this->paymentError = $paymentError;
        return $this;
    }
    /**
     * Get wallet value
     * @return string|null
     */
    public function getWallet()
    {
        return $this->wallet;
    }
    /**
     * Set wallet value
     * @param string $wallet
     * @return \StructType\PaymentResponse
     */
    public function setWallet($wallet = null)
    {
        // validation for constraint: string
        if (!is_null($wallet) && !is_string($wallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wallet, true), gettype($wallet)), __LINE__);
        }
        $this->wallet = $wallet;
        return $this;
    }
    /**
     * Get preTaxAmount value
     * @return int|null
     */
    public function getPreTaxAmount()
    {
        return $this->preTaxAmount;
    }
    /**
     * Set preTaxAmount value
     * @param int $preTaxAmount
     * @return \StructType\PaymentResponse
     */
    public function setPreTaxAmount($preTaxAmount = null)
    {
        // validation for constraint: int
        if (!is_null($preTaxAmount) && !(is_int($preTaxAmount) || ctype_digit($preTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preTaxAmount, true), gettype($preTaxAmount)), __LINE__);
        }
        $this->preTaxAmount = $preTaxAmount;
        return $this;
    }
    /**
     * Get taxRate value
     * @return string|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * Set taxRate value
     * @param string $taxRate
     * @return \StructType\PaymentResponse
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: string
        if (!is_null($taxRate) && !is_string($taxRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return int|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param int $taxAmount
     * @return \StructType\PaymentResponse
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: int
        if (!is_null($taxAmount) && !(is_int($taxAmount) || ctype_digit($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
