<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fraudManagementResponse StructType
 * @subpackage Structs
 */
class FraudManagementResponse extends AbstractStructBase
{
    /**
     * The riskControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RiskControl[]
     */
    public $riskControl;
    /**
     * The riskAnalysis
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RiskAnalysis[]
     */
    public $riskAnalysis;
    /**
     * The riskAssessments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RiskAssessments
     */
    public $riskAssessments;
    /**
     * Constructor method for fraudManagementResponse
     * @uses FraudManagementResponse::setRiskControl()
     * @uses FraudManagementResponse::setRiskAnalysis()
     * @uses FraudManagementResponse::setRiskAssessments()
     * @param \StructType\RiskControl[] $riskControl
     * @param \StructType\RiskAnalysis[] $riskAnalysis
     * @param \StructType\RiskAssessments $riskAssessments
     */
    public function __construct(array $riskControl = array(), array $riskAnalysis = array(), \StructType\RiskAssessments $riskAssessments = null)
    {
        $this
            ->setRiskControl($riskControl)
            ->setRiskAnalysis($riskAnalysis)
            ->setRiskAssessments($riskAssessments);
    }
    /**
     * Get riskControl value
     * @return \StructType\RiskControl[]|null
     */
    public function getRiskControl()
    {
        return $this->riskControl;
    }
    /**
     * This method is responsible for validating the values passed to the setRiskControl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRiskControl method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRiskControlForArrayConstraintsFromSetRiskControl(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fraudManagementResponseRiskControlItem) {
            // validation for constraint: itemType
            if (!$fraudManagementResponseRiskControlItem instanceof \StructType\RiskControl) {
                $invalidValues[] = is_object($fraudManagementResponseRiskControlItem) ? get_class($fraudManagementResponseRiskControlItem) : sprintf('%s(%s)', gettype($fraudManagementResponseRiskControlItem), var_export($fraudManagementResponseRiskControlItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The riskControl property can only contain items of type \StructType\RiskControl, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set riskControl value
     * @throws \InvalidArgumentException
     * @param \StructType\RiskControl[] $riskControl
     * @return \StructType\FraudManagementResponse
     */
    public function setRiskControl(array $riskControl = array())
    {
        // validation for constraint: array
        if ('' !== ($riskControlArrayErrorMessage = self::validateRiskControlForArrayConstraintsFromSetRiskControl($riskControl))) {
            throw new \InvalidArgumentException($riskControlArrayErrorMessage, __LINE__);
        }
        $this->riskControl = $riskControl;
        return $this;
    }
    /**
     * Add item to riskControl value
     * @throws \InvalidArgumentException
     * @param \StructType\RiskControl $item
     * @return \StructType\FraudManagementResponse
     */
    public function addToRiskControl(\StructType\RiskControl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RiskControl) {
            throw new \InvalidArgumentException(sprintf('The riskControl property can only contain items of type \StructType\RiskControl, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->riskControl[] = $item;
        return $this;
    }
    /**
     * Get riskAnalysis value
     * @return \StructType\RiskAnalysis[]|null
     */
    public function getRiskAnalysis()
    {
        return $this->riskAnalysis;
    }
    /**
     * This method is responsible for validating the values passed to the setRiskAnalysis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRiskAnalysis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRiskAnalysisForArrayConstraintsFromSetRiskAnalysis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fraudManagementResponseRiskAnalysisItem) {
            // validation for constraint: itemType
            if (!$fraudManagementResponseRiskAnalysisItem instanceof \StructType\RiskAnalysis) {
                $invalidValues[] = is_object($fraudManagementResponseRiskAnalysisItem) ? get_class($fraudManagementResponseRiskAnalysisItem) : sprintf('%s(%s)', gettype($fraudManagementResponseRiskAnalysisItem), var_export($fraudManagementResponseRiskAnalysisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The riskAnalysis property can only contain items of type \StructType\RiskAnalysis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set riskAnalysis value
     * @throws \InvalidArgumentException
     * @param \StructType\RiskAnalysis[] $riskAnalysis
     * @return \StructType\FraudManagementResponse
     */
    public function setRiskAnalysis(array $riskAnalysis = array())
    {
        // validation for constraint: array
        if ('' !== ($riskAnalysisArrayErrorMessage = self::validateRiskAnalysisForArrayConstraintsFromSetRiskAnalysis($riskAnalysis))) {
            throw new \InvalidArgumentException($riskAnalysisArrayErrorMessage, __LINE__);
        }
        $this->riskAnalysis = $riskAnalysis;
        return $this;
    }
    /**
     * Add item to riskAnalysis value
     * @throws \InvalidArgumentException
     * @param \StructType\RiskAnalysis $item
     * @return \StructType\FraudManagementResponse
     */
    public function addToRiskAnalysis(\StructType\RiskAnalysis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RiskAnalysis) {
            throw new \InvalidArgumentException(sprintf('The riskAnalysis property can only contain items of type \StructType\RiskAnalysis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->riskAnalysis[] = $item;
        return $this;
    }
    /**
     * Get riskAssessments value
     * @return \StructType\RiskAssessments|null
     */
    public function getRiskAssessments()
    {
        return $this->riskAssessments;
    }
    /**
     * Set riskAssessments value
     * @param \StructType\RiskAssessments $riskAssessments
     * @return \StructType\FraudManagementResponse
     */
    public function setRiskAssessments(\StructType\RiskAssessments $riskAssessments = null)
    {
        $this->riskAssessments = $riskAssessments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FraudManagementResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
