<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findPaymentsResult StructType
 * @subpackage Structs
 */
class FindPaymentsResult extends WsResponse
{
    /**
     * The commonResponse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommonResponse
     */
    public $commonResponse;
    /**
     * The orderResponse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrderResponse
     */
    public $orderResponse;
    /**
     * The transactionItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TransactionItem[]
     */
    public $transactionItem;
    /**
     * Constructor method for findPaymentsResult
     * @uses FindPaymentsResult::setCommonResponse()
     * @uses FindPaymentsResult::setOrderResponse()
     * @uses FindPaymentsResult::setTransactionItem()
     * @param \StructType\CommonResponse $commonResponse
     * @param \StructType\OrderResponse $orderResponse
     * @param \StructType\TransactionItem[] $transactionItem
     */
    public function __construct(\StructType\CommonResponse $commonResponse = null, \StructType\OrderResponse $orderResponse = null, array $transactionItem = array())
    {
        $this
            ->setCommonResponse($commonResponse)
            ->setOrderResponse($orderResponse)
            ->setTransactionItem($transactionItem);
    }
    /**
     * Get commonResponse value
     * @return \StructType\CommonResponse|null
     */
    public function getCommonResponse()
    {
        return $this->commonResponse;
    }
    /**
     * Set commonResponse value
     * @param \StructType\CommonResponse $commonResponse
     * @return \StructType\FindPaymentsResult
     */
    public function setCommonResponse(\StructType\CommonResponse $commonResponse = null)
    {
        $this->commonResponse = $commonResponse;
        return $this;
    }
    /**
     * Get orderResponse value
     * @return \StructType\OrderResponse|null
     */
    public function getOrderResponse()
    {
        return $this->orderResponse;
    }
    /**
     * Set orderResponse value
     * @param \StructType\OrderResponse $orderResponse
     * @return \StructType\FindPaymentsResult
     */
    public function setOrderResponse(\StructType\OrderResponse $orderResponse = null)
    {
        $this->orderResponse = $orderResponse;
        return $this;
    }
    /**
     * Get transactionItem value
     * @return \StructType\TransactionItem[]|null
     */
    public function getTransactionItem()
    {
        return $this->transactionItem;
    }
    /**
     * This method is responsible for validating the values passed to the setTransactionItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransactionItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionItemForArrayConstraintsFromSetTransactionItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $findPaymentsResultTransactionItemItem) {
            // validation for constraint: itemType
            if (!$findPaymentsResultTransactionItemItem instanceof \StructType\TransactionItem) {
                $invalidValues[] = is_object($findPaymentsResultTransactionItemItem) ? get_class($findPaymentsResultTransactionItemItem) : sprintf('%s(%s)', gettype($findPaymentsResultTransactionItemItem), var_export($findPaymentsResultTransactionItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The transactionItem property can only contain items of type \StructType\TransactionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set transactionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionItem[] $transactionItem
     * @return \StructType\FindPaymentsResult
     */
    public function setTransactionItem(array $transactionItem = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionItemArrayErrorMessage = self::validateTransactionItemForArrayConstraintsFromSetTransactionItem($transactionItem))) {
            throw new \InvalidArgumentException($transactionItemArrayErrorMessage, __LINE__);
        }
        $this->transactionItem = $transactionItem;
        return $this;
    }
    /**
     * Add item to transactionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionItem $item
     * @return \StructType\FindPaymentsResult
     */
    public function addToTransactionItem(\StructType\TransactionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionItem) {
            throw new \InvalidArgumentException(sprintf('The transactionItem property can only contain items of type \StructType\TransactionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->transactionItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FindPaymentsResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
