<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardResponse StructType
 * @subpackage Structs
 */
class CardResponse extends AbstractStructBase
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The scheme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scheme;
    /**
     * The brand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brand;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The productCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productCode;
    /**
     * The bankCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankCode;
    /**
     * The bankLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankLabel;
    /**
     * The expiryMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expiryMonth;
    /**
     * The expiryYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expiryYear;
    /**
     * The cardHolderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardHolderName;
    /**
     * The proofOfIdType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $proofOfIdType;
    /**
     * The proofOfIdNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $proofOfIdNumber;
    /**
     * Constructor method for cardResponse
     * @uses CardResponse::setNumber()
     * @uses CardResponse::setScheme()
     * @uses CardResponse::setBrand()
     * @uses CardResponse::setCountry()
     * @uses CardResponse::setProductCode()
     * @uses CardResponse::setBankCode()
     * @uses CardResponse::setBankLabel()
     * @uses CardResponse::setExpiryMonth()
     * @uses CardResponse::setExpiryYear()
     * @uses CardResponse::setCardHolderName()
     * @uses CardResponse::setProofOfIdType()
     * @uses CardResponse::setProofOfIdNumber()
     * @param string $number
     * @param string $scheme
     * @param string $brand
     * @param string $country
     * @param string $productCode
     * @param string $bankCode
     * @param string $bankLabel
     * @param int $expiryMonth
     * @param int $expiryYear
     * @param string $cardHolderName
     * @param string $proofOfIdType
     * @param string $proofOfIdNumber
     */
    public function __construct($number = null, $scheme = null, $brand = null, $country = null, $productCode = null, $bankCode = null, $bankLabel = null, $expiryMonth = null, $expiryYear = null, $cardHolderName = null, $proofOfIdType = null, $proofOfIdNumber = null)
    {
        $this
            ->setNumber($number)
            ->setScheme($scheme)
            ->setBrand($brand)
            ->setCountry($country)
            ->setProductCode($productCode)
            ->setBankCode($bankCode)
            ->setBankLabel($bankLabel)
            ->setExpiryMonth($expiryMonth)
            ->setExpiryYear($expiryYear)
            ->setCardHolderName($cardHolderName)
            ->setProofOfIdType($proofOfIdType)
            ->setProofOfIdNumber($proofOfIdNumber);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\CardResponse
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get scheme value
     * @return string|null
     */
    public function getScheme()
    {
        return $this->scheme;
    }
    /**
     * Set scheme value
     * @param string $scheme
     * @return \StructType\CardResponse
     */
    public function setScheme($scheme = null)
    {
        // validation for constraint: string
        if (!is_null($scheme) && !is_string($scheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheme, true), gettype($scheme)), __LINE__);
        }
        $this->scheme = $scheme;
        return $this;
    }
    /**
     * Get brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->brand;
    }
    /**
     * Set brand value
     * @param string $brand
     * @return \StructType\CardResponse
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->brand = $brand;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\CardResponse
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \StructType\CardResponse
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \StructType\CardResponse
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get bankLabel value
     * @return string|null
     */
    public function getBankLabel()
    {
        return $this->bankLabel;
    }
    /**
     * Set bankLabel value
     * @param string $bankLabel
     * @return \StructType\CardResponse
     */
    public function setBankLabel($bankLabel = null)
    {
        // validation for constraint: string
        if (!is_null($bankLabel) && !is_string($bankLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankLabel, true), gettype($bankLabel)), __LINE__);
        }
        $this->bankLabel = $bankLabel;
        return $this;
    }
    /**
     * Get expiryMonth value
     * @return int|null
     */
    public function getExpiryMonth()
    {
        return $this->expiryMonth;
    }
    /**
     * Set expiryMonth value
     * @param int $expiryMonth
     * @return \StructType\CardResponse
     */
    public function setExpiryMonth($expiryMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expiryMonth) && !(is_int($expiryMonth) || ctype_digit($expiryMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiryMonth, true), gettype($expiryMonth)), __LINE__);
        }
        $this->expiryMonth = $expiryMonth;
        return $this;
    }
    /**
     * Get expiryYear value
     * @return int|null
     */
    public function getExpiryYear()
    {
        return $this->expiryYear;
    }
    /**
     * Set expiryYear value
     * @param int $expiryYear
     * @return \StructType\CardResponse
     */
    public function setExpiryYear($expiryYear = null)
    {
        // validation for constraint: int
        if (!is_null($expiryYear) && !(is_int($expiryYear) || ctype_digit($expiryYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiryYear, true), gettype($expiryYear)), __LINE__);
        }
        $this->expiryYear = $expiryYear;
        return $this;
    }
    /**
     * Get cardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->cardHolderName;
    }
    /**
     * Set cardHolderName value
     * @param string $cardHolderName
     * @return \StructType\CardResponse
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        $this->cardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get proofOfIdType value
     * @return string|null
     */
    public function getProofOfIdType()
    {
        return $this->proofOfIdType;
    }
    /**
     * Set proofOfIdType value
     * @param string $proofOfIdType
     * @return \StructType\CardResponse
     */
    public function setProofOfIdType($proofOfIdType = null)
    {
        // validation for constraint: string
        if (!is_null($proofOfIdType) && !is_string($proofOfIdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proofOfIdType, true), gettype($proofOfIdType)), __LINE__);
        }
        $this->proofOfIdType = $proofOfIdType;
        return $this;
    }
    /**
     * Get proofOfIdNumber value
     * @return string|null
     */
    public function getProofOfIdNumber()
    {
        return $this->proofOfIdNumber;
    }
    /**
     * Set proofOfIdNumber value
     * @param string $proofOfIdNumber
     * @return \StructType\CardResponse
     */
    public function setProofOfIdNumber($proofOfIdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($proofOfIdNumber) && !is_string($proofOfIdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proofOfIdNumber, true), gettype($proofOfIdNumber)), __LINE__);
        }
        $this->proofOfIdNumber = $proofOfIdNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
