<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createTokenByIban
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTokenByIban $parameters
     * @return \StructType\CreateTokenByIbanResponse|bool
     */
    public function createTokenByIban(\StructType\CreateTokenByIban $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createTokenByIban($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createTokenFromTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTokenFromTransaction $parameters
     * @return \StructType\CreateTokenFromTransactionResponse|bool
     */
    public function createTokenFromTransaction(\StructType\CreateTokenFromTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createTokenFromTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePayment $parameters
     * @return \StructType\CreatePaymentResponse|bool
     */
    public function createPayment(\StructType\CreatePayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createSubscription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSubscription $parameters
     * @return \StructType\CreateSubscriptionResponse|bool
     */
    public function createSubscription(\StructType\CreateSubscription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createSubscription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateToken $parameters
     * @return \StructType\CreateTokenResponse|bool
     */
    public function createToken(\StructType\CreateToken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreatePaymentResponse|\StructType\CreateSubscriptionResponse|\StructType\CreateTokenByIbanResponse|\StructType\CreateTokenFromTransactionResponse|\StructType\CreateTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
