<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancelCapturedPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelCapturedPayment $parameters
     * @return \StructType\CancelCapturedPaymentResponse|bool
     */
    public function cancelCapturedPayment(\StructType\CancelCapturedPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelCapturedPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelPayment $parameters
     * @return \StructType\CancelPaymentResponse|bool
     */
    public function cancelPayment(\StructType\CancelPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelRefund
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelRefund $parameters
     * @return \StructType\CancelRefundResponse|bool
     */
    public function cancelRefund(\StructType\CancelRefund $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelRefund($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelSubscription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelSubscription $parameters
     * @return \StructType\CancelSubscriptionResponse|bool
     */
    public function cancelSubscription(\StructType\CancelSubscription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelSubscription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelToken $parameters
     * @return \StructType\CancelTokenResponse|bool
     */
    public function cancelToken(\StructType\CancelToken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelCapturedPaymentResponse|\StructType\CancelPaymentResponse|\StructType\CancelRefundResponse|\StructType\CancelSubscriptionResponse|\StructType\CancelTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
