<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartResponse StructType
 * @subpackage Structs
 */
class ShoppingCartResponse extends AbstractStructBase
{
    /**
     * The cartItemInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CartItemInfo[]
     */
    public $cartItemInfo;
    /**
     * Constructor method for shoppingCartResponse
     * @uses ShoppingCartResponse::setCartItemInfo()
     * @param \StructType\CartItemInfo[] $cartItemInfo
     */
    public function __construct(array $cartItemInfo = array())
    {
        $this
            ->setCartItemInfo($cartItemInfo);
    }
    /**
     * Get cartItemInfo value
     * @return \StructType\CartItemInfo[]|null
     */
    public function getCartItemInfo()
    {
        return $this->cartItemInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCartItemInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCartItemInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCartItemInfoForArrayConstraintsFromSetCartItemInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingCartResponseCartItemInfoItem) {
            // validation for constraint: itemType
            if (!$shoppingCartResponseCartItemInfoItem instanceof \StructType\CartItemInfo) {
                $invalidValues[] = is_object($shoppingCartResponseCartItemInfoItem) ? get_class($shoppingCartResponseCartItemInfoItem) : sprintf('%s(%s)', gettype($shoppingCartResponseCartItemInfoItem), var_export($shoppingCartResponseCartItemInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cartItemInfo property can only contain items of type \StructType\CartItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cartItemInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CartItemInfo[] $cartItemInfo
     * @return \StructType\ShoppingCartResponse
     */
    public function setCartItemInfo(array $cartItemInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($cartItemInfoArrayErrorMessage = self::validateCartItemInfoForArrayConstraintsFromSetCartItemInfo($cartItemInfo))) {
            throw new \InvalidArgumentException($cartItemInfoArrayErrorMessage, __LINE__);
        }
        $this->cartItemInfo = $cartItemInfo;
        return $this;
    }
    /**
     * Add item to cartItemInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CartItemInfo $item
     * @return \StructType\ShoppingCartResponse
     */
    public function addToCartItemInfo(\StructType\CartItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CartItemInfo) {
            throw new \InvalidArgumentException(sprintf('The cartItemInfo property can only contain items of type \StructType\CartItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cartItemInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingCartResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
