<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for settlementRequest StructType
 * @subpackage Structs
 */
class SettlementRequest extends AbstractStructBase
{
    /**
     * The transactionUuids
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $transactionUuids;
    /**
     * The commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $commission;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * Constructor method for settlementRequest
     * @uses SettlementRequest::setTransactionUuids()
     * @uses SettlementRequest::setCommission()
     * @uses SettlementRequest::setDate()
     * @param string[] $transactionUuids
     * @param float $commission
     * @param string $date
     */
    public function __construct(array $transactionUuids = array(), $commission = null, $date = null)
    {
        $this
            ->setTransactionUuids($transactionUuids)
            ->setCommission($commission)
            ->setDate($date);
    }
    /**
     * Get transactionUuids value
     * @return string[]|null
     */
    public function getTransactionUuids()
    {
        return $this->transactionUuids;
    }
    /**
     * This method is responsible for validating the values passed to the setTransactionUuids method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransactionUuids method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionUuidsForArrayConstraintsFromSetTransactionUuids(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlementRequestTransactionUuidsItem) {
            // validation for constraint: itemType
            if (!is_string($settlementRequestTransactionUuidsItem)) {
                $invalidValues[] = is_object($settlementRequestTransactionUuidsItem) ? get_class($settlementRequestTransactionUuidsItem) : sprintf('%s(%s)', gettype($settlementRequestTransactionUuidsItem), var_export($settlementRequestTransactionUuidsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The transactionUuids property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set transactionUuids value
     * @throws \InvalidArgumentException
     * @param string[] $transactionUuids
     * @return \StructType\SettlementRequest
     */
    public function setTransactionUuids(array $transactionUuids = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionUuidsArrayErrorMessage = self::validateTransactionUuidsForArrayConstraintsFromSetTransactionUuids($transactionUuids))) {
            throw new \InvalidArgumentException($transactionUuidsArrayErrorMessage, __LINE__);
        }
        $this->transactionUuids = $transactionUuids;
        return $this;
    }
    /**
     * Add item to transactionUuids value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SettlementRequest
     */
    public function addToTransactionUuids($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The transactionUuids property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->transactionUuids[] = $item;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\SettlementRequest
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\SettlementRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SettlementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
