<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentRequest StructType
 * @subpackage Structs
 */
class PaymentRequest extends AbstractStructBase
{
    /**
     * The transactionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionId;
    /**
     * The retryUuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retryUuid;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amount;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $currency;
    /**
     * The expectedCaptureDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedCaptureDate;
    /**
     * The manualValidation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manualValidation;
    /**
     * The paymentOptionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentOptionCode;
    /**
     * The acquirerTransientData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $acquirerTransientData;
    /**
     * The firstInstallmentDelay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $firstInstallmentDelay;
    /**
     * The overridePaymentCinematic
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overridePaymentCinematic;
    /**
     * The taxRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxRate;
    /**
     * The taxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $taxAmount;
    /**
     * Constructor method for paymentRequest
     * @uses PaymentRequest::setTransactionId()
     * @uses PaymentRequest::setRetryUuid()
     * @uses PaymentRequest::setAmount()
     * @uses PaymentRequest::setCurrency()
     * @uses PaymentRequest::setExpectedCaptureDate()
     * @uses PaymentRequest::setManualValidation()
     * @uses PaymentRequest::setPaymentOptionCode()
     * @uses PaymentRequest::setAcquirerTransientData()
     * @uses PaymentRequest::setFirstInstallmentDelay()
     * @uses PaymentRequest::setOverridePaymentCinematic()
     * @uses PaymentRequest::setTaxRate()
     * @uses PaymentRequest::setTaxAmount()
     * @param string $transactionId
     * @param string $retryUuid
     * @param int $amount
     * @param int $currency
     * @param string $expectedCaptureDate
     * @param int $manualValidation
     * @param string $paymentOptionCode
     * @param string $acquirerTransientData
     * @param int $firstInstallmentDelay
     * @param string $overridePaymentCinematic
     * @param string $taxRate
     * @param int $taxAmount
     */
    public function __construct($transactionId = null, $retryUuid = null, $amount = null, $currency = null, $expectedCaptureDate = null, $manualValidation = null, $paymentOptionCode = null, $acquirerTransientData = null, $firstInstallmentDelay = null, $overridePaymentCinematic = null, $taxRate = null, $taxAmount = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setRetryUuid($retryUuid)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setExpectedCaptureDate($expectedCaptureDate)
            ->setManualValidation($manualValidation)
            ->setPaymentOptionCode($paymentOptionCode)
            ->setAcquirerTransientData($acquirerTransientData)
            ->setFirstInstallmentDelay($firstInstallmentDelay)
            ->setOverridePaymentCinematic($overridePaymentCinematic)
            ->setTaxRate($taxRate)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get transactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param string $transactionId
     * @return \StructType\PaymentRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get retryUuid value
     * @return string|null
     */
    public function getRetryUuid()
    {
        return $this->retryUuid;
    }
    /**
     * Set retryUuid value
     * @param string $retryUuid
     * @return \StructType\PaymentRequest
     */
    public function setRetryUuid($retryUuid = null)
    {
        // validation for constraint: string
        if (!is_null($retryUuid) && !is_string($retryUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retryUuid, true), gettype($retryUuid)), __LINE__);
        }
        $this->retryUuid = $retryUuid;
        return $this;
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\PaymentRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return int|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param int $currency
     * @return \StructType\PaymentRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: int
        if (!is_null($currency) && !(is_int($currency) || ctype_digit($currency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get expectedCaptureDate value
     * @return string|null
     */
    public function getExpectedCaptureDate()
    {
        return $this->expectedCaptureDate;
    }
    /**
     * Set expectedCaptureDate value
     * @param string $expectedCaptureDate
     * @return \StructType\PaymentRequest
     */
    public function setExpectedCaptureDate($expectedCaptureDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedCaptureDate) && !is_string($expectedCaptureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedCaptureDate, true), gettype($expectedCaptureDate)), __LINE__);
        }
        $this->expectedCaptureDate = $expectedCaptureDate;
        return $this;
    }
    /**
     * Get manualValidation value
     * @return int|null
     */
    public function getManualValidation()
    {
        return $this->manualValidation;
    }
    /**
     * Set manualValidation value
     * @param int $manualValidation
     * @return \StructType\PaymentRequest
     */
    public function setManualValidation($manualValidation = null)
    {
        // validation for constraint: int
        if (!is_null($manualValidation) && !(is_int($manualValidation) || ctype_digit($manualValidation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manualValidation, true), gettype($manualValidation)), __LINE__);
        }
        $this->manualValidation = $manualValidation;
        return $this;
    }
    /**
     * Get paymentOptionCode value
     * @return string|null
     */
    public function getPaymentOptionCode()
    {
        return $this->paymentOptionCode;
    }
    /**
     * Set paymentOptionCode value
     * @param string $paymentOptionCode
     * @return \StructType\PaymentRequest
     */
    public function setPaymentOptionCode($paymentOptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentOptionCode) && !is_string($paymentOptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentOptionCode, true), gettype($paymentOptionCode)), __LINE__);
        }
        $this->paymentOptionCode = $paymentOptionCode;
        return $this;
    }
    /**
     * Get acquirerTransientData value
     * @return string|null
     */
    public function getAcquirerTransientData()
    {
        return $this->acquirerTransientData;
    }
    /**
     * Set acquirerTransientData value
     * @param string $acquirerTransientData
     * @return \StructType\PaymentRequest
     */
    public function setAcquirerTransientData($acquirerTransientData = null)
    {
        // validation for constraint: string
        if (!is_null($acquirerTransientData) && !is_string($acquirerTransientData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquirerTransientData, true), gettype($acquirerTransientData)), __LINE__);
        }
        $this->acquirerTransientData = $acquirerTransientData;
        return $this;
    }
    /**
     * Get firstInstallmentDelay value
     * @return int|null
     */
    public function getFirstInstallmentDelay()
    {
        return $this->firstInstallmentDelay;
    }
    /**
     * Set firstInstallmentDelay value
     * @param int $firstInstallmentDelay
     * @return \StructType\PaymentRequest
     */
    public function setFirstInstallmentDelay($firstInstallmentDelay = null)
    {
        // validation for constraint: int
        if (!is_null($firstInstallmentDelay) && !(is_int($firstInstallmentDelay) || ctype_digit($firstInstallmentDelay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstInstallmentDelay, true), gettype($firstInstallmentDelay)), __LINE__);
        }
        $this->firstInstallmentDelay = $firstInstallmentDelay;
        return $this;
    }
    /**
     * Get overridePaymentCinematic value
     * @return string|null
     */
    public function getOverridePaymentCinematic()
    {
        return $this->overridePaymentCinematic;
    }
    /**
     * Set overridePaymentCinematic value
     * @param string $overridePaymentCinematic
     * @return \StructType\PaymentRequest
     */
    public function setOverridePaymentCinematic($overridePaymentCinematic = null)
    {
        // validation for constraint: string
        if (!is_null($overridePaymentCinematic) && !is_string($overridePaymentCinematic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overridePaymentCinematic, true), gettype($overridePaymentCinematic)), __LINE__);
        }
        $this->overridePaymentCinematic = $overridePaymentCinematic;
        return $this;
    }
    /**
     * Get taxRate value
     * @return string|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * Set taxRate value
     * @param string $taxRate
     * @return \StructType\PaymentRequest
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: string
        if (!is_null($taxRate) && !is_string($taxRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return int|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param int $taxAmount
     * @return \StructType\PaymentRequest
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: int
        if (!is_null($taxAmount) && !(is_int($taxAmount) || ctype_digit($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
