<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderResponse StructType
 * @subpackage Structs
 */
class OrderResponse extends AbstractStructBase
{
    /**
     * The orderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderId;
    /**
     * The extInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExtInfo[]
     */
    public $extInfo;
    /**
     * Constructor method for orderResponse
     * @uses OrderResponse::setOrderId()
     * @uses OrderResponse::setExtInfo()
     * @param string $orderId
     * @param \StructType\ExtInfo[] $extInfo
     */
    public function __construct($orderId = null, array $extInfo = array())
    {
        $this
            ->setOrderId($orderId)
            ->setExtInfo($extInfo);
    }
    /**
     * Get orderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param string $orderId
     * @return \StructType\OrderResponse
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get extInfo value
     * @return \StructType\ExtInfo[]|null
     */
    public function getExtInfo()
    {
        return $this->extInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setExtInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtInfoForArrayConstraintsFromSetExtInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderResponseExtInfoItem) {
            // validation for constraint: itemType
            if (!$orderResponseExtInfoItem instanceof \StructType\ExtInfo) {
                $invalidValues[] = is_object($orderResponseExtInfoItem) ? get_class($orderResponseExtInfoItem) : sprintf('%s(%s)', gettype($orderResponseExtInfoItem), var_export($orderResponseExtInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extInfo property can only contain items of type \StructType\ExtInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtInfo[] $extInfo
     * @return \StructType\OrderResponse
     */
    public function setExtInfo(array $extInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($extInfoArrayErrorMessage = self::validateExtInfoForArrayConstraintsFromSetExtInfo($extInfo))) {
            throw new \InvalidArgumentException($extInfoArrayErrorMessage, __LINE__);
        }
        $this->extInfo = $extInfo;
        return $this;
    }
    /**
     * Add item to extInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtInfo $item
     * @return \StructType\OrderResponse
     */
    public function addToExtInfo(\StructType\ExtInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtInfo) {
            throw new \InvalidArgumentException(sprintf('The extInfo property can only contain items of type \StructType\ExtInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
