<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extraResponse StructType
 * @subpackage Structs
 */
class ExtraResponse extends AbstractStructBase
{
    /**
     * The paymentOptionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentOptionCode;
    /**
     * The paymentOptionOccNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $paymentOptionOccNumber;
    /**
     * The boletoPdfUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $boletoPdfUrl;
    /**
     * Constructor method for extraResponse
     * @uses ExtraResponse::setPaymentOptionCode()
     * @uses ExtraResponse::setPaymentOptionOccNumber()
     * @uses ExtraResponse::setBoletoPdfUrl()
     * @param string $paymentOptionCode
     * @param int $paymentOptionOccNumber
     * @param string $boletoPdfUrl
     */
    public function __construct($paymentOptionCode = null, $paymentOptionOccNumber = null, $boletoPdfUrl = null)
    {
        $this
            ->setPaymentOptionCode($paymentOptionCode)
            ->setPaymentOptionOccNumber($paymentOptionOccNumber)
            ->setBoletoPdfUrl($boletoPdfUrl);
    }
    /**
     * Get paymentOptionCode value
     * @return string|null
     */
    public function getPaymentOptionCode()
    {
        return $this->paymentOptionCode;
    }
    /**
     * Set paymentOptionCode value
     * @param string $paymentOptionCode
     * @return \StructType\ExtraResponse
     */
    public function setPaymentOptionCode($paymentOptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentOptionCode) && !is_string($paymentOptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentOptionCode, true), gettype($paymentOptionCode)), __LINE__);
        }
        $this->paymentOptionCode = $paymentOptionCode;
        return $this;
    }
    /**
     * Get paymentOptionOccNumber value
     * @return int|null
     */
    public function getPaymentOptionOccNumber()
    {
        return $this->paymentOptionOccNumber;
    }
    /**
     * Set paymentOptionOccNumber value
     * @param int $paymentOptionOccNumber
     * @return \StructType\ExtraResponse
     */
    public function setPaymentOptionOccNumber($paymentOptionOccNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paymentOptionOccNumber) && !(is_int($paymentOptionOccNumber) || ctype_digit($paymentOptionOccNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentOptionOccNumber, true), gettype($paymentOptionOccNumber)), __LINE__);
        }
        $this->paymentOptionOccNumber = $paymentOptionOccNumber;
        return $this;
    }
    /**
     * Get boletoPdfUrl value
     * @return string|null
     */
    public function getBoletoPdfUrl()
    {
        return $this->boletoPdfUrl;
    }
    /**
     * Set boletoPdfUrl value
     * @param string $boletoPdfUrl
     * @return \StructType\ExtraResponse
     */
    public function setBoletoPdfUrl($boletoPdfUrl = null)
    {
        // validation for constraint: string
        if (!is_null($boletoPdfUrl) && !is_string($boletoPdfUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boletoPdfUrl, true), gettype($boletoPdfUrl)), __LINE__);
        }
        $this->boletoPdfUrl = $boletoPdfUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtraResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
