<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardRequest StructType
 * @subpackage Structs
 */
class CardRequest extends AbstractStructBase
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The scheme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scheme;
    /**
     * The expiryMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expiryMonth;
    /**
     * The expiryYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expiryYear;
    /**
     * The cardSecurityCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardSecurityCode;
    /**
     * The cardHolderBirthDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardHolderBirthDay;
    /**
     * The paymentToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentToken;
    /**
     * The cardHolderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardHolderName;
    /**
     * The proofOfIdType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $proofOfIdType;
    /**
     * The proofOfIdNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $proofOfIdNumber;
    /**
     * The walletPayload
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $walletPayload;
    /**
     * Constructor method for cardRequest
     * @uses CardRequest::setNumber()
     * @uses CardRequest::setScheme()
     * @uses CardRequest::setExpiryMonth()
     * @uses CardRequest::setExpiryYear()
     * @uses CardRequest::setCardSecurityCode()
     * @uses CardRequest::setCardHolderBirthDay()
     * @uses CardRequest::setPaymentToken()
     * @uses CardRequest::setCardHolderName()
     * @uses CardRequest::setProofOfIdType()
     * @uses CardRequest::setProofOfIdNumber()
     * @uses CardRequest::setWalletPayload()
     * @param string $number
     * @param string $scheme
     * @param int $expiryMonth
     * @param int $expiryYear
     * @param string $cardSecurityCode
     * @param string $cardHolderBirthDay
     * @param string $paymentToken
     * @param string $cardHolderName
     * @param string $proofOfIdType
     * @param string $proofOfIdNumber
     * @param string $walletPayload
     */
    public function __construct($number = null, $scheme = null, $expiryMonth = null, $expiryYear = null, $cardSecurityCode = null, $cardHolderBirthDay = null, $paymentToken = null, $cardHolderName = null, $proofOfIdType = null, $proofOfIdNumber = null, $walletPayload = null)
    {
        $this
            ->setNumber($number)
            ->setScheme($scheme)
            ->setExpiryMonth($expiryMonth)
            ->setExpiryYear($expiryYear)
            ->setCardSecurityCode($cardSecurityCode)
            ->setCardHolderBirthDay($cardHolderBirthDay)
            ->setPaymentToken($paymentToken)
            ->setCardHolderName($cardHolderName)
            ->setProofOfIdType($proofOfIdType)
            ->setProofOfIdNumber($proofOfIdNumber)
            ->setWalletPayload($walletPayload);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\CardRequest
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get scheme value
     * @return string|null
     */
    public function getScheme()
    {
        return $this->scheme;
    }
    /**
     * Set scheme value
     * @param string $scheme
     * @return \StructType\CardRequest
     */
    public function setScheme($scheme = null)
    {
        // validation for constraint: string
        if (!is_null($scheme) && !is_string($scheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheme, true), gettype($scheme)), __LINE__);
        }
        $this->scheme = $scheme;
        return $this;
    }
    /**
     * Get expiryMonth value
     * @return int|null
     */
    public function getExpiryMonth()
    {
        return $this->expiryMonth;
    }
    /**
     * Set expiryMonth value
     * @param int $expiryMonth
     * @return \StructType\CardRequest
     */
    public function setExpiryMonth($expiryMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expiryMonth) && !(is_int($expiryMonth) || ctype_digit($expiryMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiryMonth, true), gettype($expiryMonth)), __LINE__);
        }
        $this->expiryMonth = $expiryMonth;
        return $this;
    }
    /**
     * Get expiryYear value
     * @return int|null
     */
    public function getExpiryYear()
    {
        return $this->expiryYear;
    }
    /**
     * Set expiryYear value
     * @param int $expiryYear
     * @return \StructType\CardRequest
     */
    public function setExpiryYear($expiryYear = null)
    {
        // validation for constraint: int
        if (!is_null($expiryYear) && !(is_int($expiryYear) || ctype_digit($expiryYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiryYear, true), gettype($expiryYear)), __LINE__);
        }
        $this->expiryYear = $expiryYear;
        return $this;
    }
    /**
     * Get cardSecurityCode value
     * @return string|null
     */
    public function getCardSecurityCode()
    {
        return $this->cardSecurityCode;
    }
    /**
     * Set cardSecurityCode value
     * @param string $cardSecurityCode
     * @return \StructType\CardRequest
     */
    public function setCardSecurityCode($cardSecurityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardSecurityCode) && !is_string($cardSecurityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardSecurityCode, true), gettype($cardSecurityCode)), __LINE__);
        }
        $this->cardSecurityCode = $cardSecurityCode;
        return $this;
    }
    /**
     * Get cardHolderBirthDay value
     * @return string|null
     */
    public function getCardHolderBirthDay()
    {
        return $this->cardHolderBirthDay;
    }
    /**
     * Set cardHolderBirthDay value
     * @param string $cardHolderBirthDay
     * @return \StructType\CardRequest
     */
    public function setCardHolderBirthDay($cardHolderBirthDay = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderBirthDay) && !is_string($cardHolderBirthDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderBirthDay, true), gettype($cardHolderBirthDay)), __LINE__);
        }
        $this->cardHolderBirthDay = $cardHolderBirthDay;
        return $this;
    }
    /**
     * Get paymentToken value
     * @return string|null
     */
    public function getPaymentToken()
    {
        return $this->paymentToken;
    }
    /**
     * Set paymentToken value
     * @param string $paymentToken
     * @return \StructType\CardRequest
     */
    public function setPaymentToken($paymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($paymentToken) && !is_string($paymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentToken, true), gettype($paymentToken)), __LINE__);
        }
        $this->paymentToken = $paymentToken;
        return $this;
    }
    /**
     * Get cardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->cardHolderName;
    }
    /**
     * Set cardHolderName value
     * @param string $cardHolderName
     * @return \StructType\CardRequest
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        $this->cardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get proofOfIdType value
     * @return string|null
     */
    public function getProofOfIdType()
    {
        return $this->proofOfIdType;
    }
    /**
     * Set proofOfIdType value
     * @param string $proofOfIdType
     * @return \StructType\CardRequest
     */
    public function setProofOfIdType($proofOfIdType = null)
    {
        // validation for constraint: string
        if (!is_null($proofOfIdType) && !is_string($proofOfIdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proofOfIdType, true), gettype($proofOfIdType)), __LINE__);
        }
        $this->proofOfIdType = $proofOfIdType;
        return $this;
    }
    /**
     * Get proofOfIdNumber value
     * @return string|null
     */
    public function getProofOfIdNumber()
    {
        return $this->proofOfIdNumber;
    }
    /**
     * Set proofOfIdNumber value
     * @param string $proofOfIdNumber
     * @return \StructType\CardRequest
     */
    public function setProofOfIdNumber($proofOfIdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($proofOfIdNumber) && !is_string($proofOfIdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proofOfIdNumber, true), gettype($proofOfIdNumber)), __LINE__);
        }
        $this->proofOfIdNumber = $proofOfIdNumber;
        return $this;
    }
    /**
     * Get walletPayload value
     * @return string|null
     */
    public function getWalletPayload()
    {
        return $this->walletPayload;
    }
    /**
     * Set walletPayload value
     * @param string $walletPayload
     * @return \StructType\CardRequest
     */
    public function setWalletPayload($walletPayload = null)
    {
        // validation for constraint: string
        if (!is_null($walletPayload) && !is_string($walletPayload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletPayload, true), gettype($walletPayload)), __LINE__);
        }
        $this->walletPayload = $walletPayload;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
