<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updatePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePayment $parameters
     * @return \StructType\UpdatePaymentResponse|bool
     */
    public function updatePayment(\StructType\UpdatePayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePaymentDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePaymentDetails $parameters
     * @return \StructType\UpdatePaymentDetailsResponse|bool
     */
    public function updatePaymentDetails(\StructType\UpdatePaymentDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePaymentDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateToken $parameters
     * @return \StructType\UpdateTokenResponse|bool
     */
    public function updateToken(\StructType\UpdateToken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updateToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRefund
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRefund $parameters
     * @return \StructType\UpdateRefundResponse|bool
     */
    public function updateRefund(\StructType\UpdateRefund $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRefund($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSubscription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSubscription $parameters
     * @return \StructType\UpdateSubscriptionResponse|bool
     */
    public function updateSubscription(\StructType\UpdateSubscription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSubscription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdatePaymentDetailsResponse|\StructType\UpdatePaymentResponse|\StructType\UpdateRefundResponse|\StructType\UpdateSubscriptionResponse|\StructType\UpdateTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
