<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reactivate ServiceType
 * @subpackage Services
 */
class Reactivate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reactivateToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReactivateToken $parameters
     * @return \StructType\ReactivateTokenResponse|bool
     */
    public function reactivateToken(\StructType\ReactivateToken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->reactivateToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReactivateTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
