<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getPaymentDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaymentDetails $parameters
     * @return \StructType\GetPaymentDetailsResponse|bool
     */
    public function getPaymentDetails(\StructType\GetPaymentDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPaymentDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPaymentUuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaymentUuid $parameters
     * @return \StructType\GetPaymentUuidResponse|bool
     */
    public function getPaymentUuid(\StructType\GetPaymentUuid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPaymentUuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubscriptionDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubscriptionDetails $parameters
     * @return \StructType\GetSubscriptionDetailsResponse|bool
     */
    public function getSubscriptionDetails(\StructType\GetSubscriptionDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSubscriptionDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTokenDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTokenDetails $parameters
     * @return \StructType\GetTokenDetailsResponse|bool
     */
    public function getTokenDetails(\StructType\GetTokenDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getTokenDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetPaymentDetailsResponse|\StructType\GetPaymentUuidResponse|\StructType\GetSubscriptionDetailsResponse|\StructType\GetTokenDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
