<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://efaturatest.innova.com.tr/ClientInterfaceService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://efaturatest.innova.com.tr/ClientInterfaceService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Invoice ServiceType
 */
$invoice = new \ServiceType\Invoice($options);
/**
 * Sample call for InvoiceInquiry operation/method
 */
if ($invoice->InvoiceInquiry(new \StructType\InvoiceInquiry()) !== false) {
    print_r($invoice->getResult());
} else {
    print_r($invoice->getLastError());
}
/**
 * Samples for Return ServiceType
 */
$return = new \ServiceType\_Return($options);
/**
 * Sample call for ReturnInvoiceWithKEP operation/method
 */
if ($return->ReturnInvoiceWithKEP(new \StructType\ReturnInvoiceWithKEP()) !== false) {
    print_r($return->getResult());
} else {
    print_r($return->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendInvoices operation/method
 */
if ($send->SendInvoices(new \StructType\SendInvoices()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendInvoicesRaw operation/method
 */
if ($send->SendInvoicesRaw(new \StructType\SendInvoicesRaw()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetInvoices operation/method
 */
if ($get->GetInvoices(new \StructType\GetInvoices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicesRaw operation/method
 */
if ($get->GetInvoicesRaw(new \StructType\GetInvoicesRaw()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReconciliationDetail operation/method
 */
if ($get->GetReconciliationDetail(new \StructType\GetReconciliationDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomers operation/method
 */
if ($get->GetCustomers(new \StructType\GetCustomers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Reply ServiceType
 */
$reply = new \ServiceType\Reply($options);
/**
 * Sample call for ReplyInvoices operation/method
 */
if ($reply->ReplyInvoices(new \StructType\ReplyInvoices()) !== false) {
    print_r($reply->getResult());
} else {
    print_r($reply->getLastError());
}
/**
 * Samples for Customer ServiceType
 */
$customer = new \ServiceType\Customer($options);
/**
 * Sample call for CustomerInquiry operation/method
 */
if ($customer->CustomerInquiry(new \StructType\CustomerInquiry()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Reconciliation ServiceType
 */
$reconciliation = new \ServiceType\Reconciliation($options);
/**
 * Sample call for ReconciliationInquiry operation/method
 */
if ($reconciliation->ReconciliationInquiry(new \StructType\ReconciliationInquiry()) !== false) {
    print_r($reconciliation->getResult());
} else {
    print_r($reconciliation->getLastError());
}
/**
 * Samples for Do ServiceType
 */
$do = new \ServiceType\_Do($options);
/**
 * Sample call for DoReconciliation operation/method
 */
if ($do->DoReconciliation(new \StructType\DoReconciliation()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Samples for Download ServiceType
 */
$download = new \ServiceType\Download($options);
/**
 * Sample call for DownloadInvoice operation/method
 */
if ($download->DownloadInvoice(new \StructType\DownloadInvoice()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Samples for Preview ServiceType
 */
$preview = new \ServiceType\Preview($options);
/**
 * Sample call for PreviewInvoice operation/method
 */
if ($preview->PreviewInvoice(new \StructType\PreviewInvoice()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewInvoiceRaw operation/method
 */
if ($preview->PreviewInvoiceRaw(new \StructType\PreviewInvoiceRaw()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateNewContact operation/method
 */
if ($create->CreateNewContact(new \StructType\CreateNewContact()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for PingClientInterfaceService operation/method
 */
if ($ping->PingClientInterfaceService(new \StructType\PingClientInterfaceService()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelInvoice operation/method
 */
if ($cancel->CancelInvoice(new \StructType\CancelInvoice()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Custom ServiceType
 */
$custom = new \ServiceType\Custom($options);
/**
 * Sample call for CustomPostBoxEnvelopeInquiry operation/method
 */
if ($custom->CustomPostBoxEnvelopeInquiry(new \StructType\CustomPostBoxEnvelopeInquiry()) !== false) {
    print_r($custom->getResult());
} else {
    print_r($custom->getLastError());
}
/**
 * Samples for Approve ServiceType
 */
$approve = new \ServiceType\Approve($options);
/**
 * Sample call for ApproveDraftInvoice operation/method
 */
if ($approve->ApproveDraftInvoice(new \StructType\ApproveDraftInvoice()) !== false) {
    print_r($approve->getResult());
} else {
    print_r($approve->getLastError());
}
/**
 * Samples for Repeat ServiceType
 */
$repeat = new \ServiceType\Repeat($options);
/**
 * Sample call for RepeatEArchiveSms operation/method
 */
if ($repeat->RepeatEArchiveSms(new \StructType\RepeatEArchiveSms()) !== false) {
    print_r($repeat->getResult());
} else {
    print_r($repeat->getLastError());
}
