<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportMeans StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransportMeans
 * @subpackage Structs
 */
class TransportMeans extends AbstractStructBase
{
    /**
     * The AirTransport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirTransport
     */
    public $AirTransport;
    /**
     * The DirectionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectionCode;
    /**
     * The DriverParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParty
     */
    public $DriverParty;
    /**
     * The JourneyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JourneyID;
    /**
     * The MaritimeTransport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MaritimeTransport
     */
    public $MaritimeTransport;
    /**
     * The MeasurementDimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDimension
     */
    public $MeasurementDimension;
    /**
     * The OwnerParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $OwnerParty;
    /**
     * The PassengerParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParty
     */
    public $PassengerParty;
    /**
     * The RailTransport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RailTransport
     */
    public $RailTransport;
    /**
     * The RegistrationNationality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $RegistrationNationality;
    /**
     * The RegistrationNationalityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationNationalityID;
    /**
     * The ReportingParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $ReportingParty;
    /**
     * The RoadTransport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoadTransport
     */
    public $RoadTransport;
    /**
     * The Stowage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Stowage
     */
    public $Stowage;
    /**
     * The TradeServiceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TradeServiceCode;
    /**
     * The TransportMeansTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransportMeansTypeCode;
    /**
     * Constructor method for TransportMeans
     * @uses TransportMeans::setAirTransport()
     * @uses TransportMeans::setDirectionCode()
     * @uses TransportMeans::setDriverParty()
     * @uses TransportMeans::setJourneyID()
     * @uses TransportMeans::setMaritimeTransport()
     * @uses TransportMeans::setMeasurementDimension()
     * @uses TransportMeans::setOwnerParty()
     * @uses TransportMeans::setPassengerParty()
     * @uses TransportMeans::setRailTransport()
     * @uses TransportMeans::setRegistrationNationality()
     * @uses TransportMeans::setRegistrationNationalityID()
     * @uses TransportMeans::setReportingParty()
     * @uses TransportMeans::setRoadTransport()
     * @uses TransportMeans::setStowage()
     * @uses TransportMeans::setTradeServiceCode()
     * @uses TransportMeans::setTransportMeansTypeCode()
     * @param \StructType\AirTransport $airTransport
     * @param string $directionCode
     * @param \ArrayType\ArrayOfParty $driverParty
     * @param string $journeyID
     * @param \StructType\MaritimeTransport $maritimeTransport
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @param \StructType\Party $ownerParty
     * @param \ArrayType\ArrayOfParty $passengerParty
     * @param \StructType\RailTransport $railTransport
     * @param \ArrayType\ArrayOfstring $registrationNationality
     * @param string $registrationNationalityID
     * @param \StructType\Party $reportingParty
     * @param \StructType\RoadTransport $roadTransport
     * @param \StructType\Stowage $stowage
     * @param string $tradeServiceCode
     * @param string $transportMeansTypeCode
     */
    public function __construct(\StructType\AirTransport $airTransport = null, $directionCode = null, \ArrayType\ArrayOfParty $driverParty = null, $journeyID = null, \StructType\MaritimeTransport $maritimeTransport = null, \ArrayType\ArrayOfDimension $measurementDimension = null, \StructType\Party $ownerParty = null, \ArrayType\ArrayOfParty $passengerParty = null, \StructType\RailTransport $railTransport = null, \ArrayType\ArrayOfstring $registrationNationality = null, $registrationNationalityID = null, \StructType\Party $reportingParty = null, \StructType\RoadTransport $roadTransport = null, \StructType\Stowage $stowage = null, $tradeServiceCode = null, $transportMeansTypeCode = null)
    {
        $this
            ->setAirTransport($airTransport)
            ->setDirectionCode($directionCode)
            ->setDriverParty($driverParty)
            ->setJourneyID($journeyID)
            ->setMaritimeTransport($maritimeTransport)
            ->setMeasurementDimension($measurementDimension)
            ->setOwnerParty($ownerParty)
            ->setPassengerParty($passengerParty)
            ->setRailTransport($railTransport)
            ->setRegistrationNationality($registrationNationality)
            ->setRegistrationNationalityID($registrationNationalityID)
            ->setReportingParty($reportingParty)
            ->setRoadTransport($roadTransport)
            ->setStowage($stowage)
            ->setTradeServiceCode($tradeServiceCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode);
    }
    /**
     * Get AirTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirTransport|null
     */
    public function getAirTransport()
    {
        return isset($this->AirTransport) ? $this->AirTransport : null;
    }
    /**
     * Set AirTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirTransport $airTransport
     * @return \StructType\TransportMeans
     */
    public function setAirTransport(\StructType\AirTransport $airTransport = null)
    {
        if (is_null($airTransport) || (is_array($airTransport) && empty($airTransport))) {
            unset($this->AirTransport);
        } else {
            $this->AirTransport = $airTransport;
        }
        return $this;
    }
    /**
     * Get DirectionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectionCode()
    {
        return isset($this->DirectionCode) ? $this->DirectionCode : null;
    }
    /**
     * Set DirectionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directionCode
     * @return \StructType\TransportMeans
     */
    public function setDirectionCode($directionCode = null)
    {
        // validation for constraint: string
        if (!is_null($directionCode) && !is_string($directionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directionCode, true), gettype($directionCode)), __LINE__);
        }
        if (is_null($directionCode) || (is_array($directionCode) && empty($directionCode))) {
            unset($this->DirectionCode);
        } else {
            $this->DirectionCode = $directionCode;
        }
        return $this;
    }
    /**
     * Get DriverParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParty|null
     */
    public function getDriverParty()
    {
        return isset($this->DriverParty) ? $this->DriverParty : null;
    }
    /**
     * Set DriverParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParty $driverParty
     * @return \StructType\TransportMeans
     */
    public function setDriverParty(\ArrayType\ArrayOfParty $driverParty = null)
    {
        if (is_null($driverParty) || (is_array($driverParty) && empty($driverParty))) {
            unset($this->DriverParty);
        } else {
            $this->DriverParty = $driverParty;
        }
        return $this;
    }
    /**
     * Get JourneyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJourneyID()
    {
        return isset($this->JourneyID) ? $this->JourneyID : null;
    }
    /**
     * Set JourneyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $journeyID
     * @return \StructType\TransportMeans
     */
    public function setJourneyID($journeyID = null)
    {
        // validation for constraint: string
        if (!is_null($journeyID) && !is_string($journeyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyID, true), gettype($journeyID)), __LINE__);
        }
        if (is_null($journeyID) || (is_array($journeyID) && empty($journeyID))) {
            unset($this->JourneyID);
        } else {
            $this->JourneyID = $journeyID;
        }
        return $this;
    }
    /**
     * Get MaritimeTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MaritimeTransport|null
     */
    public function getMaritimeTransport()
    {
        return isset($this->MaritimeTransport) ? $this->MaritimeTransport : null;
    }
    /**
     * Set MaritimeTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MaritimeTransport $maritimeTransport
     * @return \StructType\TransportMeans
     */
    public function setMaritimeTransport(\StructType\MaritimeTransport $maritimeTransport = null)
    {
        if (is_null($maritimeTransport) || (is_array($maritimeTransport) && empty($maritimeTransport))) {
            unset($this->MaritimeTransport);
        } else {
            $this->MaritimeTransport = $maritimeTransport;
        }
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDimension|null
     */
    public function getMeasurementDimension()
    {
        return isset($this->MeasurementDimension) ? $this->MeasurementDimension : null;
    }
    /**
     * Set MeasurementDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @return \StructType\TransportMeans
     */
    public function setMeasurementDimension(\ArrayType\ArrayOfDimension $measurementDimension = null)
    {
        if (is_null($measurementDimension) || (is_array($measurementDimension) && empty($measurementDimension))) {
            unset($this->MeasurementDimension);
        } else {
            $this->MeasurementDimension = $measurementDimension;
        }
        return $this;
    }
    /**
     * Get OwnerParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getOwnerParty()
    {
        return isset($this->OwnerParty) ? $this->OwnerParty : null;
    }
    /**
     * Set OwnerParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $ownerParty
     * @return \StructType\TransportMeans
     */
    public function setOwnerParty(\StructType\Party $ownerParty = null)
    {
        if (is_null($ownerParty) || (is_array($ownerParty) && empty($ownerParty))) {
            unset($this->OwnerParty);
        } else {
            $this->OwnerParty = $ownerParty;
        }
        return $this;
    }
    /**
     * Get PassengerParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParty|null
     */
    public function getPassengerParty()
    {
        return isset($this->PassengerParty) ? $this->PassengerParty : null;
    }
    /**
     * Set PassengerParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParty $passengerParty
     * @return \StructType\TransportMeans
     */
    public function setPassengerParty(\ArrayType\ArrayOfParty $passengerParty = null)
    {
        if (is_null($passengerParty) || (is_array($passengerParty) && empty($passengerParty))) {
            unset($this->PassengerParty);
        } else {
            $this->PassengerParty = $passengerParty;
        }
        return $this;
    }
    /**
     * Get RailTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RailTransport|null
     */
    public function getRailTransport()
    {
        return isset($this->RailTransport) ? $this->RailTransport : null;
    }
    /**
     * Set RailTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RailTransport $railTransport
     * @return \StructType\TransportMeans
     */
    public function setRailTransport(\StructType\RailTransport $railTransport = null)
    {
        if (is_null($railTransport) || (is_array($railTransport) && empty($railTransport))) {
            unset($this->RailTransport);
        } else {
            $this->RailTransport = $railTransport;
        }
        return $this;
    }
    /**
     * Get RegistrationNationality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getRegistrationNationality()
    {
        return isset($this->RegistrationNationality) ? $this->RegistrationNationality : null;
    }
    /**
     * Set RegistrationNationality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $registrationNationality
     * @return \StructType\TransportMeans
     */
    public function setRegistrationNationality(\ArrayType\ArrayOfstring $registrationNationality = null)
    {
        if (is_null($registrationNationality) || (is_array($registrationNationality) && empty($registrationNationality))) {
            unset($this->RegistrationNationality);
        } else {
            $this->RegistrationNationality = $registrationNationality;
        }
        return $this;
    }
    /**
     * Get RegistrationNationalityID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationNationalityID()
    {
        return isset($this->RegistrationNationalityID) ? $this->RegistrationNationalityID : null;
    }
    /**
     * Set RegistrationNationalityID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrationNationalityID
     * @return \StructType\TransportMeans
     */
    public function setRegistrationNationalityID($registrationNationalityID = null)
    {
        // validation for constraint: string
        if (!is_null($registrationNationalityID) && !is_string($registrationNationalityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationNationalityID, true), gettype($registrationNationalityID)), __LINE__);
        }
        if (is_null($registrationNationalityID) || (is_array($registrationNationalityID) && empty($registrationNationalityID))) {
            unset($this->RegistrationNationalityID);
        } else {
            $this->RegistrationNationalityID = $registrationNationalityID;
        }
        return $this;
    }
    /**
     * Get ReportingParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getReportingParty()
    {
        return isset($this->ReportingParty) ? $this->ReportingParty : null;
    }
    /**
     * Set ReportingParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $reportingParty
     * @return \StructType\TransportMeans
     */
    public function setReportingParty(\StructType\Party $reportingParty = null)
    {
        if (is_null($reportingParty) || (is_array($reportingParty) && empty($reportingParty))) {
            unset($this->ReportingParty);
        } else {
            $this->ReportingParty = $reportingParty;
        }
        return $this;
    }
    /**
     * Get RoadTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoadTransport|null
     */
    public function getRoadTransport()
    {
        return isset($this->RoadTransport) ? $this->RoadTransport : null;
    }
    /**
     * Set RoadTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RoadTransport $roadTransport
     * @return \StructType\TransportMeans
     */
    public function setRoadTransport(\StructType\RoadTransport $roadTransport = null)
    {
        if (is_null($roadTransport) || (is_array($roadTransport) && empty($roadTransport))) {
            unset($this->RoadTransport);
        } else {
            $this->RoadTransport = $roadTransport;
        }
        return $this;
    }
    /**
     * Get Stowage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Stowage|null
     */
    public function getStowage()
    {
        return isset($this->Stowage) ? $this->Stowage : null;
    }
    /**
     * Set Stowage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Stowage $stowage
     * @return \StructType\TransportMeans
     */
    public function setStowage(\StructType\Stowage $stowage = null)
    {
        if (is_null($stowage) || (is_array($stowage) && empty($stowage))) {
            unset($this->Stowage);
        } else {
            $this->Stowage = $stowage;
        }
        return $this;
    }
    /**
     * Get TradeServiceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTradeServiceCode()
    {
        return isset($this->TradeServiceCode) ? $this->TradeServiceCode : null;
    }
    /**
     * Set TradeServiceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tradeServiceCode
     * @return \StructType\TransportMeans
     */
    public function setTradeServiceCode($tradeServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($tradeServiceCode) && !is_string($tradeServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tradeServiceCode, true), gettype($tradeServiceCode)), __LINE__);
        }
        if (is_null($tradeServiceCode) || (is_array($tradeServiceCode) && empty($tradeServiceCode))) {
            unset($this->TradeServiceCode);
        } else {
            $this->TradeServiceCode = $tradeServiceCode;
        }
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransportMeansTypeCode()
    {
        return isset($this->TransportMeansTypeCode) ? $this->TransportMeansTypeCode : null;
    }
    /**
     * Set TransportMeansTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transportMeansTypeCode
     * @return \StructType\TransportMeans
     */
    public function setTransportMeansTypeCode($transportMeansTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportMeansTypeCode) && !is_string($transportMeansTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportMeansTypeCode, true), gettype($transportMeansTypeCode)), __LINE__);
        }
        if (is_null($transportMeansTypeCode) || (is_array($transportMeansTypeCode) && empty($transportMeansTypeCode))) {
            unset($this->TransportMeansTypeCode);
        } else {
            $this->TransportMeansTypeCode = $transportMeansTypeCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportMeans
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
