<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportHandlingUnit StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransportHandlingUnit
 * @subpackage Structs
 */
class TransportHandlingUnit extends AbstractStructBase
{
    /**
     * The ActualPackage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPackage
     */
    public $ActualPackage;
    /**
     * The CustomsIdentifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $CustomsIdentifications;
    /**
     * The DamageRemarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $DamageRemarks;
    /**
     * The FloorSpaceMeasurementDimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dimension
     */
    public $FloorSpaceMeasurementDimension;
    /**
     * The HandlingCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandlingInstructions;
    /**
     * The HazardousGoodsTransit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHazardousGoodsTransit
     */
    public $HazardousGoodsTransit;
    /**
     * The HazardousRiskIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HazardousRiskIndicator;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The MaximumTemperature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Temperature
     */
    public $MaximumTemperature;
    /**
     * The MeasurementDimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDimension
     */
    public $MeasurementDimension;
    /**
     * The MinimumTemperature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Temperature
     */
    public $MinimumTemperature;
    /**
     * The PalletSpaceMeasurementDimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dimension
     */
    public $PalletSpaceMeasurementDimension;
    /**
     * The ShipmentDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentReference
     */
    public $ShipmentDocumentReference;
    /**
     * The TotalGoodsItemQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalPackageQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalPackageQuantity;
    /**
     * The TraceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TraceID;
    /**
     * The TransportEquipments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTransportEquipment
     */
    public $TransportEquipments;
    /**
     * The TransportHandlingUnitTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransportHandlingUnitTypeCode;
    /**
     * The TransportMeans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTransportMeans
     */
    public $TransportMeans;
    /**
     * Constructor method for TransportHandlingUnit
     * @uses TransportHandlingUnit::setActualPackage()
     * @uses TransportHandlingUnit::setCustomsIdentifications()
     * @uses TransportHandlingUnit::setDamageRemarks()
     * @uses TransportHandlingUnit::setFloorSpaceMeasurementDimension()
     * @uses TransportHandlingUnit::setHandlingCode()
     * @uses TransportHandlingUnit::setHandlingInstructions()
     * @uses TransportHandlingUnit::setHazardousGoodsTransit()
     * @uses TransportHandlingUnit::setHazardousRiskIndicator()
     * @uses TransportHandlingUnit::setID()
     * @uses TransportHandlingUnit::setMaximumTemperature()
     * @uses TransportHandlingUnit::setMeasurementDimension()
     * @uses TransportHandlingUnit::setMinimumTemperature()
     * @uses TransportHandlingUnit::setPalletSpaceMeasurementDimension()
     * @uses TransportHandlingUnit::setShipmentDocumentReference()
     * @uses TransportHandlingUnit::setTotalGoodsItemQuantity()
     * @uses TransportHandlingUnit::setTotalPackageQuantity()
     * @uses TransportHandlingUnit::setTraceID()
     * @uses TransportHandlingUnit::setTransportEquipments()
     * @uses TransportHandlingUnit::setTransportHandlingUnitTypeCode()
     * @uses TransportHandlingUnit::setTransportMeans()
     * @param \ArrayType\ArrayOfPackage $actualPackage
     * @param \ArrayType\ArrayOfstring $customsIdentifications
     * @param \ArrayType\ArrayOfstring $damageRemarks
     * @param \StructType\Dimension $floorSpaceMeasurementDimension
     * @param string $handlingCode
     * @param string $handlingInstructions
     * @param \ArrayType\ArrayOfHazardousGoodsTransit $hazardousGoodsTransit
     * @param bool $hazardousRiskIndicator
     * @param string $iD
     * @param \StructType\Temperature $maximumTemperature
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @param \StructType\Temperature $minimumTemperature
     * @param \StructType\Dimension $palletSpaceMeasurementDimension
     * @param \ArrayType\ArrayOfDocumentReference $shipmentDocumentReference
     * @param float $totalGoodsItemQuantity
     * @param float $totalPackageQuantity
     * @param string $traceID
     * @param \ArrayType\ArrayOfTransportEquipment $transportEquipments
     * @param string $transportHandlingUnitTypeCode
     * @param \ArrayType\ArrayOfTransportMeans $transportMeans
     */
    public function __construct(\ArrayType\ArrayOfPackage $actualPackage = null, \ArrayType\ArrayOfstring $customsIdentifications = null, \ArrayType\ArrayOfstring $damageRemarks = null, \StructType\Dimension $floorSpaceMeasurementDimension = null, $handlingCode = null, $handlingInstructions = null, \ArrayType\ArrayOfHazardousGoodsTransit $hazardousGoodsTransit = null, $hazardousRiskIndicator = null, $iD = null, \StructType\Temperature $maximumTemperature = null, \ArrayType\ArrayOfDimension $measurementDimension = null, \StructType\Temperature $minimumTemperature = null, \StructType\Dimension $palletSpaceMeasurementDimension = null, \ArrayType\ArrayOfDocumentReference $shipmentDocumentReference = null, $totalGoodsItemQuantity = null, $totalPackageQuantity = null, $traceID = null, \ArrayType\ArrayOfTransportEquipment $transportEquipments = null, $transportHandlingUnitTypeCode = null, \ArrayType\ArrayOfTransportMeans $transportMeans = null)
    {
        $this
            ->setActualPackage($actualPackage)
            ->setCustomsIdentifications($customsIdentifications)
            ->setDamageRemarks($damageRemarks)
            ->setFloorSpaceMeasurementDimension($floorSpaceMeasurementDimension)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setHazardousGoodsTransit($hazardousGoodsTransit)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setID($iD)
            ->setMaximumTemperature($maximumTemperature)
            ->setMeasurementDimension($measurementDimension)
            ->setMinimumTemperature($minimumTemperature)
            ->setPalletSpaceMeasurementDimension($palletSpaceMeasurementDimension)
            ->setShipmentDocumentReference($shipmentDocumentReference)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalPackageQuantity($totalPackageQuantity)
            ->setTraceID($traceID)
            ->setTransportEquipments($transportEquipments)
            ->setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode)
            ->setTransportMeans($transportMeans);
    }
    /**
     * Get ActualPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPackage|null
     */
    public function getActualPackage()
    {
        return isset($this->ActualPackage) ? $this->ActualPackage : null;
    }
    /**
     * Set ActualPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPackage $actualPackage
     * @return \StructType\TransportHandlingUnit
     */
    public function setActualPackage(\ArrayType\ArrayOfPackage $actualPackage = null)
    {
        if (is_null($actualPackage) || (is_array($actualPackage) && empty($actualPackage))) {
            unset($this->ActualPackage);
        } else {
            $this->ActualPackage = $actualPackage;
        }
        return $this;
    }
    /**
     * Get CustomsIdentifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getCustomsIdentifications()
    {
        return isset($this->CustomsIdentifications) ? $this->CustomsIdentifications : null;
    }
    /**
     * Set CustomsIdentifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $customsIdentifications
     * @return \StructType\TransportHandlingUnit
     */
    public function setCustomsIdentifications(\ArrayType\ArrayOfstring $customsIdentifications = null)
    {
        if (is_null($customsIdentifications) || (is_array($customsIdentifications) && empty($customsIdentifications))) {
            unset($this->CustomsIdentifications);
        } else {
            $this->CustomsIdentifications = $customsIdentifications;
        }
        return $this;
    }
    /**
     * Get DamageRemarks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDamageRemarks()
    {
        return isset($this->DamageRemarks) ? $this->DamageRemarks : null;
    }
    /**
     * Set DamageRemarks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $damageRemarks
     * @return \StructType\TransportHandlingUnit
     */
    public function setDamageRemarks(\ArrayType\ArrayOfstring $damageRemarks = null)
    {
        if (is_null($damageRemarks) || (is_array($damageRemarks) && empty($damageRemarks))) {
            unset($this->DamageRemarks);
        } else {
            $this->DamageRemarks = $damageRemarks;
        }
        return $this;
    }
    /**
     * Get FloorSpaceMeasurementDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dimension|null
     */
    public function getFloorSpaceMeasurementDimension()
    {
        return isset($this->FloorSpaceMeasurementDimension) ? $this->FloorSpaceMeasurementDimension : null;
    }
    /**
     * Set FloorSpaceMeasurementDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Dimension $floorSpaceMeasurementDimension
     * @return \StructType\TransportHandlingUnit
     */
    public function setFloorSpaceMeasurementDimension(\StructType\Dimension $floorSpaceMeasurementDimension = null)
    {
        if (is_null($floorSpaceMeasurementDimension) || (is_array($floorSpaceMeasurementDimension) && empty($floorSpaceMeasurementDimension))) {
            unset($this->FloorSpaceMeasurementDimension);
        } else {
            $this->FloorSpaceMeasurementDimension = $floorSpaceMeasurementDimension;
        }
        return $this;
    }
    /**
     * Get HandlingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandlingCode()
    {
        return isset($this->HandlingCode) ? $this->HandlingCode : null;
    }
    /**
     * Set HandlingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handlingCode
     * @return \StructType\TransportHandlingUnit
     */
    public function setHandlingCode($handlingCode = null)
    {
        // validation for constraint: string
        if (!is_null($handlingCode) && !is_string($handlingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingCode, true), gettype($handlingCode)), __LINE__);
        }
        if (is_null($handlingCode) || (is_array($handlingCode) && empty($handlingCode))) {
            unset($this->HandlingCode);
        } else {
            $this->HandlingCode = $handlingCode;
        }
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandlingInstructions()
    {
        return isset($this->HandlingInstructions) ? $this->HandlingInstructions : null;
    }
    /**
     * Set HandlingInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handlingInstructions
     * @return \StructType\TransportHandlingUnit
     */
    public function setHandlingInstructions($handlingInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($handlingInstructions) && !is_string($handlingInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingInstructions, true), gettype($handlingInstructions)), __LINE__);
        }
        if (is_null($handlingInstructions) || (is_array($handlingInstructions) && empty($handlingInstructions))) {
            unset($this->HandlingInstructions);
        } else {
            $this->HandlingInstructions = $handlingInstructions;
        }
        return $this;
    }
    /**
     * Get HazardousGoodsTransit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHazardousGoodsTransit|null
     */
    public function getHazardousGoodsTransit()
    {
        return isset($this->HazardousGoodsTransit) ? $this->HazardousGoodsTransit : null;
    }
    /**
     * Set HazardousGoodsTransit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHazardousGoodsTransit $hazardousGoodsTransit
     * @return \StructType\TransportHandlingUnit
     */
    public function setHazardousGoodsTransit(\ArrayType\ArrayOfHazardousGoodsTransit $hazardousGoodsTransit = null)
    {
        if (is_null($hazardousGoodsTransit) || (is_array($hazardousGoodsTransit) && empty($hazardousGoodsTransit))) {
            unset($this->HazardousGoodsTransit);
        } else {
            $this->HazardousGoodsTransit = $hazardousGoodsTransit;
        }
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return bool|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param bool $hazardousRiskIndicator
     * @return \StructType\TransportHandlingUnit
     */
    public function setHazardousRiskIndicator($hazardousRiskIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardousRiskIndicator) && !is_bool($hazardousRiskIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hazardousRiskIndicator, true), gettype($hazardousRiskIndicator)), __LINE__);
        }
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\TransportHandlingUnit
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Temperature|null
     */
    public function getMaximumTemperature()
    {
        return isset($this->MaximumTemperature) ? $this->MaximumTemperature : null;
    }
    /**
     * Set MaximumTemperature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Temperature $maximumTemperature
     * @return \StructType\TransportHandlingUnit
     */
    public function setMaximumTemperature(\StructType\Temperature $maximumTemperature = null)
    {
        if (is_null($maximumTemperature) || (is_array($maximumTemperature) && empty($maximumTemperature))) {
            unset($this->MaximumTemperature);
        } else {
            $this->MaximumTemperature = $maximumTemperature;
        }
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDimension|null
     */
    public function getMeasurementDimension()
    {
        return isset($this->MeasurementDimension) ? $this->MeasurementDimension : null;
    }
    /**
     * Set MeasurementDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @return \StructType\TransportHandlingUnit
     */
    public function setMeasurementDimension(\ArrayType\ArrayOfDimension $measurementDimension = null)
    {
        if (is_null($measurementDimension) || (is_array($measurementDimension) && empty($measurementDimension))) {
            unset($this->MeasurementDimension);
        } else {
            $this->MeasurementDimension = $measurementDimension;
        }
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Temperature|null
     */
    public function getMinimumTemperature()
    {
        return isset($this->MinimumTemperature) ? $this->MinimumTemperature : null;
    }
    /**
     * Set MinimumTemperature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Temperature $minimumTemperature
     * @return \StructType\TransportHandlingUnit
     */
    public function setMinimumTemperature(\StructType\Temperature $minimumTemperature = null)
    {
        if (is_null($minimumTemperature) || (is_array($minimumTemperature) && empty($minimumTemperature))) {
            unset($this->MinimumTemperature);
        } else {
            $this->MinimumTemperature = $minimumTemperature;
        }
        return $this;
    }
    /**
     * Get PalletSpaceMeasurementDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dimension|null
     */
    public function getPalletSpaceMeasurementDimension()
    {
        return isset($this->PalletSpaceMeasurementDimension) ? $this->PalletSpaceMeasurementDimension : null;
    }
    /**
     * Set PalletSpaceMeasurementDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Dimension $palletSpaceMeasurementDimension
     * @return \StructType\TransportHandlingUnit
     */
    public function setPalletSpaceMeasurementDimension(\StructType\Dimension $palletSpaceMeasurementDimension = null)
    {
        if (is_null($palletSpaceMeasurementDimension) || (is_array($palletSpaceMeasurementDimension) && empty($palletSpaceMeasurementDimension))) {
            unset($this->PalletSpaceMeasurementDimension);
        } else {
            $this->PalletSpaceMeasurementDimension = $palletSpaceMeasurementDimension;
        }
        return $this;
    }
    /**
     * Get ShipmentDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentReference|null
     */
    public function getShipmentDocumentReference()
    {
        return isset($this->ShipmentDocumentReference) ? $this->ShipmentDocumentReference : null;
    }
    /**
     * Set ShipmentDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentReference $shipmentDocumentReference
     * @return \StructType\TransportHandlingUnit
     */
    public function setShipmentDocumentReference(\ArrayType\ArrayOfDocumentReference $shipmentDocumentReference = null)
    {
        if (is_null($shipmentDocumentReference) || (is_array($shipmentDocumentReference) && empty($shipmentDocumentReference))) {
            unset($this->ShipmentDocumentReference);
        } else {
            $this->ShipmentDocumentReference = $shipmentDocumentReference;
        }
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return float|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param float $totalGoodsItemQuantity
     * @return \StructType\TransportHandlingUnit
     */
    public function setTotalGoodsItemQuantity($totalGoodsItemQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($totalGoodsItemQuantity) && !(is_float($totalGoodsItemQuantity) || is_numeric($totalGoodsItemQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalGoodsItemQuantity, true), gettype($totalGoodsItemQuantity)), __LINE__);
        }
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalPackageQuantity value
     * @return float|null
     */
    public function getTotalPackageQuantity()
    {
        return $this->TotalPackageQuantity;
    }
    /**
     * Set TotalPackageQuantity value
     * @param float $totalPackageQuantity
     * @return \StructType\TransportHandlingUnit
     */
    public function setTotalPackageQuantity($totalPackageQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($totalPackageQuantity) && !(is_float($totalPackageQuantity) || is_numeric($totalPackageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPackageQuantity, true), gettype($totalPackageQuantity)), __LINE__);
        }
        $this->TotalPackageQuantity = $totalPackageQuantity;
        return $this;
    }
    /**
     * Get TraceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraceID()
    {
        return isset($this->TraceID) ? $this->TraceID : null;
    }
    /**
     * Set TraceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traceID
     * @return \StructType\TransportHandlingUnit
     */
    public function setTraceID($traceID = null)
    {
        // validation for constraint: string
        if (!is_null($traceID) && !is_string($traceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceID, true), gettype($traceID)), __LINE__);
        }
        if (is_null($traceID) || (is_array($traceID) && empty($traceID))) {
            unset($this->TraceID);
        } else {
            $this->TraceID = $traceID;
        }
        return $this;
    }
    /**
     * Get TransportEquipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTransportEquipment|null
     */
    public function getTransportEquipments()
    {
        return isset($this->TransportEquipments) ? $this->TransportEquipments : null;
    }
    /**
     * Set TransportEquipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTransportEquipment $transportEquipments
     * @return \StructType\TransportHandlingUnit
     */
    public function setTransportEquipments(\ArrayType\ArrayOfTransportEquipment $transportEquipments = null)
    {
        if (is_null($transportEquipments) || (is_array($transportEquipments) && empty($transportEquipments))) {
            unset($this->TransportEquipments);
        } else {
            $this->TransportEquipments = $transportEquipments;
        }
        return $this;
    }
    /**
     * Get TransportHandlingUnitTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransportHandlingUnitTypeCode()
    {
        return isset($this->TransportHandlingUnitTypeCode) ? $this->TransportHandlingUnitTypeCode : null;
    }
    /**
     * Set TransportHandlingUnitTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transportHandlingUnitTypeCode
     * @return \StructType\TransportHandlingUnit
     */
    public function setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportHandlingUnitTypeCode) && !is_string($transportHandlingUnitTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportHandlingUnitTypeCode, true), gettype($transportHandlingUnitTypeCode)), __LINE__);
        }
        if (is_null($transportHandlingUnitTypeCode) || (is_array($transportHandlingUnitTypeCode) && empty($transportHandlingUnitTypeCode))) {
            unset($this->TransportHandlingUnitTypeCode);
        } else {
            $this->TransportHandlingUnitTypeCode = $transportHandlingUnitTypeCode;
        }
        return $this;
    }
    /**
     * Get TransportMeans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTransportMeans|null
     */
    public function getTransportMeans()
    {
        return isset($this->TransportMeans) ? $this->TransportMeans : null;
    }
    /**
     * Set TransportMeans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTransportMeans $transportMeans
     * @return \StructType\TransportHandlingUnit
     */
    public function setTransportMeans(\ArrayType\ArrayOfTransportMeans $transportMeans = null)
    {
        if (is_null($transportMeans) || (is_array($transportMeans) && empty($transportMeans))) {
            unset($this->TransportMeans);
        } else {
            $this->TransportMeans = $transportMeans;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportHandlingUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
