<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportEquipment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransportEquipment
 * @subpackage Structs
 */
class TransportEquipment extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The TransportEquipmentTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransportEquipmentTypeCode;
    /**
     * Constructor method for TransportEquipment
     * @uses TransportEquipment::setDescription()
     * @uses TransportEquipment::setID()
     * @uses TransportEquipment::setTransportEquipmentTypeCode()
     * @param string $description
     * @param string $iD
     * @param string $transportEquipmentTypeCode
     */
    public function __construct($description = null, $iD = null, $transportEquipmentTypeCode = null)
    {
        $this
            ->setDescription($description)
            ->setID($iD)
            ->setTransportEquipmentTypeCode($transportEquipmentTypeCode);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\TransportEquipment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\TransportEquipment
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get TransportEquipmentTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransportEquipmentTypeCode()
    {
        return isset($this->TransportEquipmentTypeCode) ? $this->TransportEquipmentTypeCode : null;
    }
    /**
     * Set TransportEquipmentTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transportEquipmentTypeCode
     * @return \StructType\TransportEquipment
     */
    public function setTransportEquipmentTypeCode($transportEquipmentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportEquipmentTypeCode) && !is_string($transportEquipmentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportEquipmentTypeCode, true), gettype($transportEquipmentTypeCode)), __LINE__);
        }
        if (is_null($transportEquipmentTypeCode) || (is_array($transportEquipmentTypeCode) && empty($transportEquipmentTypeCode))) {
            unset($this->TransportEquipmentTypeCode);
        } else {
            $this->TransportEquipmentTypeCode = $transportEquipmentTypeCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportEquipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
