<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Temperature StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Temperature
 * @subpackage Structs
 */
class Temperature extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Description;
    /**
     * The Measure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $Measure;
    /**
     * Constructor method for Temperature
     * @uses Temperature::setAttributeID()
     * @uses Temperature::setDescription()
     * @uses Temperature::setMeasure()
     * @param string $attributeID
     * @param \ArrayType\ArrayOfstring $description
     * @param \StructType\Measure $measure
     */
    public function __construct($attributeID = null, \ArrayType\ArrayOfstring $description = null, \StructType\Measure $measure = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setDescription($description)
            ->setMeasure($measure);
    }
    /**
     * Get AttributeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeID()
    {
        return isset($this->AttributeID) ? $this->AttributeID : null;
    }
    /**
     * Set AttributeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeID
     * @return \StructType\Temperature
     */
    public function setAttributeID($attributeID = null)
    {
        // validation for constraint: string
        if (!is_null($attributeID) && !is_string($attributeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeID, true), gettype($attributeID)), __LINE__);
        }
        if (is_null($attributeID) || (is_array($attributeID) && empty($attributeID))) {
            unset($this->AttributeID);
        } else {
            $this->AttributeID = $attributeID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $description
     * @return \StructType\Temperature
     */
    public function setDescription(\ArrayType\ArrayOfstring $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Measure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getMeasure()
    {
        return isset($this->Measure) ? $this->Measure : null;
    }
    /**
     * Set Measure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $measure
     * @return \StructType\Temperature
     */
    public function setMeasure(\StructType\Measure $measure = null)
    {
        if (is_null($measure) || (is_array($measure) && empty($measure))) {
            unset($this->Measure);
        } else {
            $this->Measure = $measure;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Temperature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
