<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSubtotal StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TaxSubtotal
 * @subpackage Structs
 */
class TaxSubtotal extends AbstractStructBase
{
    /**
     * The BaseUnitMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseUnitMeasure;
    /**
     * The BaseUnitMeasureCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseUnitMeasureCode;
    /**
     * The CalculationSequenceNumeric
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CalculationSequenceNumeric;
    /**
     * The PerUnitAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $PerUnitAmount;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Percent;
    /**
     * The TaxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $TaxAmount;
    /**
     * The TaxCategoryExemptionReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxCategoryExemptionReason;
    /**
     * The TaxCategoryExemptionReasonCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxCategoryExemptionReasonCode;
    /**
     * The TaxCategorySchemeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxCategorySchemeCode;
    /**
     * The TaxCategorySchemeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxCategorySchemeName;
    /**
     * The TaxableAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $TaxableAmount;
    /**
     * The TransactionCurrencyTaxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $TransactionCurrencyTaxAmount;
    /**
     * Constructor method for TaxSubtotal
     * @uses TaxSubtotal::setBaseUnitMeasure()
     * @uses TaxSubtotal::setBaseUnitMeasureCode()
     * @uses TaxSubtotal::setCalculationSequenceNumeric()
     * @uses TaxSubtotal::setPerUnitAmount()
     * @uses TaxSubtotal::setPercent()
     * @uses TaxSubtotal::setTaxAmount()
     * @uses TaxSubtotal::setTaxCategoryExemptionReason()
     * @uses TaxSubtotal::setTaxCategoryExemptionReasonCode()
     * @uses TaxSubtotal::setTaxCategorySchemeCode()
     * @uses TaxSubtotal::setTaxCategorySchemeName()
     * @uses TaxSubtotal::setTaxableAmount()
     * @uses TaxSubtotal::setTransactionCurrencyTaxAmount()
     * @param string $baseUnitMeasure
     * @param string $baseUnitMeasureCode
     * @param float $calculationSequenceNumeric
     * @param \StructType\Amount $perUnitAmount
     * @param float $percent
     * @param \StructType\Amount $taxAmount
     * @param string $taxCategoryExemptionReason
     * @param string $taxCategoryExemptionReasonCode
     * @param string $taxCategorySchemeCode
     * @param string $taxCategorySchemeName
     * @param \StructType\Amount $taxableAmount
     * @param \StructType\Amount $transactionCurrencyTaxAmount
     */
    public function __construct($baseUnitMeasure = null, $baseUnitMeasureCode = null, $calculationSequenceNumeric = null, \StructType\Amount $perUnitAmount = null, $percent = null, \StructType\Amount $taxAmount = null, $taxCategoryExemptionReason = null, $taxCategoryExemptionReasonCode = null, $taxCategorySchemeCode = null, $taxCategorySchemeName = null, \StructType\Amount $taxableAmount = null, \StructType\Amount $transactionCurrencyTaxAmount = null)
    {
        $this
            ->setBaseUnitMeasure($baseUnitMeasure)
            ->setBaseUnitMeasureCode($baseUnitMeasureCode)
            ->setCalculationSequenceNumeric($calculationSequenceNumeric)
            ->setPerUnitAmount($perUnitAmount)
            ->setPercent($percent)
            ->setTaxAmount($taxAmount)
            ->setTaxCategoryExemptionReason($taxCategoryExemptionReason)
            ->setTaxCategoryExemptionReasonCode($taxCategoryExemptionReasonCode)
            ->setTaxCategorySchemeCode($taxCategorySchemeCode)
            ->setTaxCategorySchemeName($taxCategorySchemeName)
            ->setTaxableAmount($taxableAmount)
            ->setTransactionCurrencyTaxAmount($transactionCurrencyTaxAmount);
    }
    /**
     * Get BaseUnitMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseUnitMeasure()
    {
        return isset($this->BaseUnitMeasure) ? $this->BaseUnitMeasure : null;
    }
    /**
     * Set BaseUnitMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseUnitMeasure
     * @return \StructType\TaxSubtotal
     */
    public function setBaseUnitMeasure($baseUnitMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($baseUnitMeasure) && !is_string($baseUnitMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseUnitMeasure, true), gettype($baseUnitMeasure)), __LINE__);
        }
        if (is_null($baseUnitMeasure) || (is_array($baseUnitMeasure) && empty($baseUnitMeasure))) {
            unset($this->BaseUnitMeasure);
        } else {
            $this->BaseUnitMeasure = $baseUnitMeasure;
        }
        return $this;
    }
    /**
     * Get BaseUnitMeasureCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseUnitMeasureCode()
    {
        return isset($this->BaseUnitMeasureCode) ? $this->BaseUnitMeasureCode : null;
    }
    /**
     * Set BaseUnitMeasureCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseUnitMeasureCode
     * @return \StructType\TaxSubtotal
     */
    public function setBaseUnitMeasureCode($baseUnitMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($baseUnitMeasureCode) && !is_string($baseUnitMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseUnitMeasureCode, true), gettype($baseUnitMeasureCode)), __LINE__);
        }
        if (is_null($baseUnitMeasureCode) || (is_array($baseUnitMeasureCode) && empty($baseUnitMeasureCode))) {
            unset($this->BaseUnitMeasureCode);
        } else {
            $this->BaseUnitMeasureCode = $baseUnitMeasureCode;
        }
        return $this;
    }
    /**
     * Get CalculationSequenceNumeric value
     * @return float|null
     */
    public function getCalculationSequenceNumeric()
    {
        return $this->CalculationSequenceNumeric;
    }
    /**
     * Set CalculationSequenceNumeric value
     * @param float $calculationSequenceNumeric
     * @return \StructType\TaxSubtotal
     */
    public function setCalculationSequenceNumeric($calculationSequenceNumeric = null)
    {
        // validation for constraint: float
        if (!is_null($calculationSequenceNumeric) && !(is_float($calculationSequenceNumeric) || is_numeric($calculationSequenceNumeric))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calculationSequenceNumeric, true), gettype($calculationSequenceNumeric)), __LINE__);
        }
        $this->CalculationSequenceNumeric = $calculationSequenceNumeric;
        return $this;
    }
    /**
     * Get PerUnitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getPerUnitAmount()
    {
        return isset($this->PerUnitAmount) ? $this->PerUnitAmount : null;
    }
    /**
     * Set PerUnitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $perUnitAmount
     * @return \StructType\TaxSubtotal
     */
    public function setPerUnitAmount(\StructType\Amount $perUnitAmount = null)
    {
        if (is_null($perUnitAmount) || (is_array($perUnitAmount) && empty($perUnitAmount))) {
            unset($this->PerUnitAmount);
        } else {
            $this->PerUnitAmount = $perUnitAmount;
        }
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\TaxSubtotal
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $taxAmount
     * @return \StructType\TaxSubtotal
     */
    public function setTaxAmount(\StructType\Amount $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxCategoryExemptionReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxCategoryExemptionReason()
    {
        return isset($this->TaxCategoryExemptionReason) ? $this->TaxCategoryExemptionReason : null;
    }
    /**
     * Set TaxCategoryExemptionReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxCategoryExemptionReason
     * @return \StructType\TaxSubtotal
     */
    public function setTaxCategoryExemptionReason($taxCategoryExemptionReason = null)
    {
        // validation for constraint: string
        if (!is_null($taxCategoryExemptionReason) && !is_string($taxCategoryExemptionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCategoryExemptionReason, true), gettype($taxCategoryExemptionReason)), __LINE__);
        }
        if (is_null($taxCategoryExemptionReason) || (is_array($taxCategoryExemptionReason) && empty($taxCategoryExemptionReason))) {
            unset($this->TaxCategoryExemptionReason);
        } else {
            $this->TaxCategoryExemptionReason = $taxCategoryExemptionReason;
        }
        return $this;
    }
    /**
     * Get TaxCategoryExemptionReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxCategoryExemptionReasonCode()
    {
        return isset($this->TaxCategoryExemptionReasonCode) ? $this->TaxCategoryExemptionReasonCode : null;
    }
    /**
     * Set TaxCategoryExemptionReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxCategoryExemptionReasonCode
     * @return \StructType\TaxSubtotal
     */
    public function setTaxCategoryExemptionReasonCode($taxCategoryExemptionReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCategoryExemptionReasonCode) && !is_string($taxCategoryExemptionReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCategoryExemptionReasonCode, true), gettype($taxCategoryExemptionReasonCode)), __LINE__);
        }
        if (is_null($taxCategoryExemptionReasonCode) || (is_array($taxCategoryExemptionReasonCode) && empty($taxCategoryExemptionReasonCode))) {
            unset($this->TaxCategoryExemptionReasonCode);
        } else {
            $this->TaxCategoryExemptionReasonCode = $taxCategoryExemptionReasonCode;
        }
        return $this;
    }
    /**
     * Get TaxCategorySchemeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxCategorySchemeCode()
    {
        return isset($this->TaxCategorySchemeCode) ? $this->TaxCategorySchemeCode : null;
    }
    /**
     * Set TaxCategorySchemeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxCategorySchemeCode
     * @return \StructType\TaxSubtotal
     */
    public function setTaxCategorySchemeCode($taxCategorySchemeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCategorySchemeCode) && !is_string($taxCategorySchemeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCategorySchemeCode, true), gettype($taxCategorySchemeCode)), __LINE__);
        }
        if (is_null($taxCategorySchemeCode) || (is_array($taxCategorySchemeCode) && empty($taxCategorySchemeCode))) {
            unset($this->TaxCategorySchemeCode);
        } else {
            $this->TaxCategorySchemeCode = $taxCategorySchemeCode;
        }
        return $this;
    }
    /**
     * Get TaxCategorySchemeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxCategorySchemeName()
    {
        return isset($this->TaxCategorySchemeName) ? $this->TaxCategorySchemeName : null;
    }
    /**
     * Set TaxCategorySchemeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxCategorySchemeName
     * @return \StructType\TaxSubtotal
     */
    public function setTaxCategorySchemeName($taxCategorySchemeName = null)
    {
        // validation for constraint: string
        if (!is_null($taxCategorySchemeName) && !is_string($taxCategorySchemeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCategorySchemeName, true), gettype($taxCategorySchemeName)), __LINE__);
        }
        if (is_null($taxCategorySchemeName) || (is_array($taxCategorySchemeName) && empty($taxCategorySchemeName))) {
            unset($this->TaxCategorySchemeName);
        } else {
            $this->TaxCategorySchemeName = $taxCategorySchemeName;
        }
        return $this;
    }
    /**
     * Get TaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getTaxableAmount()
    {
        return isset($this->TaxableAmount) ? $this->TaxableAmount : null;
    }
    /**
     * Set TaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $taxableAmount
     * @return \StructType\TaxSubtotal
     */
    public function setTaxableAmount(\StructType\Amount $taxableAmount = null)
    {
        if (is_null($taxableAmount) || (is_array($taxableAmount) && empty($taxableAmount))) {
            unset($this->TaxableAmount);
        } else {
            $this->TaxableAmount = $taxableAmount;
        }
        return $this;
    }
    /**
     * Get TransactionCurrencyTaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getTransactionCurrencyTaxAmount()
    {
        return isset($this->TransactionCurrencyTaxAmount) ? $this->TransactionCurrencyTaxAmount : null;
    }
    /**
     * Set TransactionCurrencyTaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $transactionCurrencyTaxAmount
     * @return \StructType\TaxSubtotal
     */
    public function setTransactionCurrencyTaxAmount(\StructType\Amount $transactionCurrencyTaxAmount = null)
    {
        if (is_null($transactionCurrencyTaxAmount) || (is_array($transactionCurrencyTaxAmount) && empty($transactionCurrencyTaxAmount))) {
            unset($this->TransactionCurrencyTaxAmount);
        } else {
            $this->TransactionCurrencyTaxAmount = $transactionCurrencyTaxAmount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxSubtotal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
