<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Stowage StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Stowage
 * @subpackage Structs
 */
class Stowage extends AbstractStructBase
{
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLocation
     */
    public $Location;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationID;
    /**
     * The MeasurementDimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDimension
     */
    public $MeasurementDimension;
    /**
     * Constructor method for Stowage
     * @uses Stowage::setLocation()
     * @uses Stowage::setLocationID()
     * @uses Stowage::setMeasurementDimension()
     * @param \ArrayType\ArrayOfLocation $location
     * @param string $locationID
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     */
    public function __construct(\ArrayType\ArrayOfLocation $location = null, $locationID = null, \ArrayType\ArrayOfDimension $measurementDimension = null)
    {
        $this
            ->setLocation($location)
            ->setLocationID($locationID)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLocation|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLocation $location
     * @return \StructType\Stowage
     */
    public function setLocation(\ArrayType\ArrayOfLocation $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationID
     * @return \StructType\Stowage
     */
    public function setLocationID($locationID = null)
    {
        // validation for constraint: string
        if (!is_null($locationID) && !is_string($locationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationID, true), gettype($locationID)), __LINE__);
        }
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDimension|null
     */
    public function getMeasurementDimension()
    {
        return isset($this->MeasurementDimension) ? $this->MeasurementDimension : null;
    }
    /**
     * Set MeasurementDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @return \StructType\Stowage
     */
    public function setMeasurementDimension(\ArrayType\ArrayOfDimension $measurementDimension = null)
    {
        if (is_null($measurementDimension) || (is_array($measurementDimension) && empty($measurementDimension))) {
            unset($this->MeasurementDimension);
        } else {
            $this->MeasurementDimension = $measurementDimension;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Stowage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
