<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsConfigurationInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SmsConfigurationInfo
 * @subpackage Structs
 */
class SmsConfigurationInfo extends AbstractStructBase
{
    /**
     * The GsmNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GsmNumber;
    /**
     * The IsSentWithSms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSentWithSms;
    /**
     * The SmsBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SmsBody;
    /**
     * Constructor method for SmsConfigurationInfo
     * @uses SmsConfigurationInfo::setGsmNumber()
     * @uses SmsConfigurationInfo::setIsSentWithSms()
     * @uses SmsConfigurationInfo::setSmsBody()
     * @param string $gsmNumber
     * @param bool $isSentWithSms
     * @param string $smsBody
     */
    public function __construct($gsmNumber = null, $isSentWithSms = null, $smsBody = null)
    {
        $this
            ->setGsmNumber($gsmNumber)
            ->setIsSentWithSms($isSentWithSms)
            ->setSmsBody($smsBody);
    }
    /**
     * Get GsmNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGsmNumber()
    {
        return isset($this->GsmNumber) ? $this->GsmNumber : null;
    }
    /**
     * Set GsmNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gsmNumber
     * @return \StructType\SmsConfigurationInfo
     */
    public function setGsmNumber($gsmNumber = null)
    {
        // validation for constraint: string
        if (!is_null($gsmNumber) && !is_string($gsmNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsmNumber, true), gettype($gsmNumber)), __LINE__);
        }
        if (is_null($gsmNumber) || (is_array($gsmNumber) && empty($gsmNumber))) {
            unset($this->GsmNumber);
        } else {
            $this->GsmNumber = $gsmNumber;
        }
        return $this;
    }
    /**
     * Get IsSentWithSms value
     * @return bool|null
     */
    public function getIsSentWithSms()
    {
        return $this->IsSentWithSms;
    }
    /**
     * Set IsSentWithSms value
     * @param bool $isSentWithSms
     * @return \StructType\SmsConfigurationInfo
     */
    public function setIsSentWithSms($isSentWithSms = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSentWithSms) && !is_bool($isSentWithSms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSentWithSms, true), gettype($isSentWithSms)), __LINE__);
        }
        $this->IsSentWithSms = $isSentWithSms;
        return $this;
    }
    /**
     * Get SmsBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmsBody()
    {
        return isset($this->SmsBody) ? $this->SmsBody : null;
    }
    /**
     * Set SmsBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smsBody
     * @return \StructType\SmsConfigurationInfo
     */
    public function setSmsBody($smsBody = null)
    {
        // validation for constraint: string
        if (!is_null($smsBody) && !is_string($smsBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsBody, true), gettype($smsBody)), __LINE__);
        }
        if (is_null($smsBody) || (is_array($smsBody) && empty($smsBody))) {
            unset($this->SmsBody);
        } else {
            $this->SmsBody = $smsBody;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SmsConfigurationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
