<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Shipment
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The DeclaredCustomsValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The Delivery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Delivery
     */
    public $Delivery;
    /**
     * The FirstArrivalPortLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Location
     */
    public $FirstArrivalPortLocation;
    /**
     * The FreeOnBoardValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $FreeOnBoardValueAmount;
    /**
     * The GoodsItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGoodsItem
     */
    public $GoodsItem;
    /**
     * The GrossVolumeMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $GrossVolumeMeasure;
    /**
     * The GrossWeightMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $GrossWeightMeasure;
    /**
     * The HandlingCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandlingInstructions;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The InsuranceValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $InsuranceValueAmount;
    /**
     * The LastExitPortLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Location
     */
    public $LastExitPortLocation;
    /**
     * The NetVolumeMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $NetVolumeMeasure;
    /**
     * The NetWeightMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $NetWeightMeasure;
    /**
     * The ReturnAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $ReturnAddress;
    /**
     * The ShipmentStage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfShipmentStage
     */
    public $ShipmentStage;
    /**
     * The SpecialInstructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $SpecialInstructions;
    /**
     * The TotalGoodsItemQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalTransportHandlingUnitQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalTransportHandlingUnitQuantity;
    /**
     * The TransportHandlingUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTransportHandlingUnit
     */
    public $TransportHandlingUnit;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setDeclaredCustomsValueAmount()
     * @uses Shipment::setDeclaredForCarriageValueAmount()
     * @uses Shipment::setDeclaredStatisticsValueAmount()
     * @uses Shipment::setDelivery()
     * @uses Shipment::setFirstArrivalPortLocation()
     * @uses Shipment::setFreeOnBoardValueAmount()
     * @uses Shipment::setGoodsItem()
     * @uses Shipment::setGrossVolumeMeasure()
     * @uses Shipment::setGrossWeightMeasure()
     * @uses Shipment::setHandlingCode()
     * @uses Shipment::setHandlingInstructions()
     * @uses Shipment::setID()
     * @uses Shipment::setInsuranceValueAmount()
     * @uses Shipment::setLastExitPortLocation()
     * @uses Shipment::setNetVolumeMeasure()
     * @uses Shipment::setNetWeightMeasure()
     * @uses Shipment::setReturnAddress()
     * @uses Shipment::setShipmentStage()
     * @uses Shipment::setSpecialInstructions()
     * @uses Shipment::setTotalGoodsItemQuantity()
     * @uses Shipment::setTotalTransportHandlingUnitQuantity()
     * @uses Shipment::setTransportHandlingUnit()
     * @param \StructType\Amount $declaredCustomsValueAmount
     * @param \StructType\Amount $declaredForCarriageValueAmount
     * @param \StructType\Amount $declaredStatisticsValueAmount
     * @param \StructType\Delivery $delivery
     * @param \StructType\Location $firstArrivalPortLocation
     * @param \StructType\Amount $freeOnBoardValueAmount
     * @param \ArrayType\ArrayOfGoodsItem $goodsItem
     * @param \StructType\Measure $grossVolumeMeasure
     * @param \StructType\Measure $grossWeightMeasure
     * @param string $handlingCode
     * @param string $handlingInstructions
     * @param string $iD
     * @param \StructType\Amount $insuranceValueAmount
     * @param \StructType\Location $lastExitPortLocation
     * @param \StructType\Measure $netVolumeMeasure
     * @param \StructType\Measure $netWeightMeasure
     * @param \StructType\Address $returnAddress
     * @param \ArrayType\ArrayOfShipmentStage $shipmentStage
     * @param \ArrayType\ArrayOfstring $specialInstructions
     * @param float $totalGoodsItemQuantity
     * @param float $totalTransportHandlingUnitQuantity
     * @param \ArrayType\ArrayOfTransportHandlingUnit $transportHandlingUnit
     */
    public function __construct(\StructType\Amount $declaredCustomsValueAmount = null, \StructType\Amount $declaredForCarriageValueAmount = null, \StructType\Amount $declaredStatisticsValueAmount = null, \StructType\Delivery $delivery = null, \StructType\Location $firstArrivalPortLocation = null, \StructType\Amount $freeOnBoardValueAmount = null, \ArrayType\ArrayOfGoodsItem $goodsItem = null, \StructType\Measure $grossVolumeMeasure = null, \StructType\Measure $grossWeightMeasure = null, $handlingCode = null, $handlingInstructions = null, $iD = null, \StructType\Amount $insuranceValueAmount = null, \StructType\Location $lastExitPortLocation = null, \StructType\Measure $netVolumeMeasure = null, \StructType\Measure $netWeightMeasure = null, \StructType\Address $returnAddress = null, \ArrayType\ArrayOfShipmentStage $shipmentStage = null, \ArrayType\ArrayOfstring $specialInstructions = null, $totalGoodsItemQuantity = null, $totalTransportHandlingUnitQuantity = null, \ArrayType\ArrayOfTransportHandlingUnit $transportHandlingUnit = null)
    {
        $this
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setDelivery($delivery)
            ->setFirstArrivalPortLocation($firstArrivalPortLocation)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setGoodsItem($goodsItem)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setID($iD)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setLastExitPortLocation($lastExitPortLocation)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setReturnAddress($returnAddress)
            ->setShipmentStage($shipmentStage)
            ->setSpecialInstructions($specialInstructions)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity)
            ->setTransportHandlingUnit($transportHandlingUnit);
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return isset($this->DeclaredCustomsValueAmount) ? $this->DeclaredCustomsValueAmount : null;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $declaredCustomsValueAmount
     * @return \StructType\Shipment
     */
    public function setDeclaredCustomsValueAmount(\StructType\Amount $declaredCustomsValueAmount = null)
    {
        if (is_null($declaredCustomsValueAmount) || (is_array($declaredCustomsValueAmount) && empty($declaredCustomsValueAmount))) {
            unset($this->DeclaredCustomsValueAmount);
        } else {
            $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        }
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return isset($this->DeclaredForCarriageValueAmount) ? $this->DeclaredForCarriageValueAmount : null;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $declaredForCarriageValueAmount
     * @return \StructType\Shipment
     */
    public function setDeclaredForCarriageValueAmount(\StructType\Amount $declaredForCarriageValueAmount = null)
    {
        if (is_null($declaredForCarriageValueAmount) || (is_array($declaredForCarriageValueAmount) && empty($declaredForCarriageValueAmount))) {
            unset($this->DeclaredForCarriageValueAmount);
        } else {
            $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        }
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return isset($this->DeclaredStatisticsValueAmount) ? $this->DeclaredStatisticsValueAmount : null;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $declaredStatisticsValueAmount
     * @return \StructType\Shipment
     */
    public function setDeclaredStatisticsValueAmount(\StructType\Amount $declaredStatisticsValueAmount = null)
    {
        if (is_null($declaredStatisticsValueAmount) || (is_array($declaredStatisticsValueAmount) && empty($declaredStatisticsValueAmount))) {
            unset($this->DeclaredStatisticsValueAmount);
        } else {
            $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        }
        return $this;
    }
    /**
     * Get Delivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Delivery|null
     */
    public function getDelivery()
    {
        return isset($this->Delivery) ? $this->Delivery : null;
    }
    /**
     * Set Delivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Delivery $delivery
     * @return \StructType\Shipment
     */
    public function setDelivery(\StructType\Delivery $delivery = null)
    {
        if (is_null($delivery) || (is_array($delivery) && empty($delivery))) {
            unset($this->Delivery);
        } else {
            $this->Delivery = $delivery;
        }
        return $this;
    }
    /**
     * Get FirstArrivalPortLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Location|null
     */
    public function getFirstArrivalPortLocation()
    {
        return isset($this->FirstArrivalPortLocation) ? $this->FirstArrivalPortLocation : null;
    }
    /**
     * Set FirstArrivalPortLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Location $firstArrivalPortLocation
     * @return \StructType\Shipment
     */
    public function setFirstArrivalPortLocation(\StructType\Location $firstArrivalPortLocation = null)
    {
        if (is_null($firstArrivalPortLocation) || (is_array($firstArrivalPortLocation) && empty($firstArrivalPortLocation))) {
            unset($this->FirstArrivalPortLocation);
        } else {
            $this->FirstArrivalPortLocation = $firstArrivalPortLocation;
        }
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return isset($this->FreeOnBoardValueAmount) ? $this->FreeOnBoardValueAmount : null;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $freeOnBoardValueAmount
     * @return \StructType\Shipment
     */
    public function setFreeOnBoardValueAmount(\StructType\Amount $freeOnBoardValueAmount = null)
    {
        if (is_null($freeOnBoardValueAmount) || (is_array($freeOnBoardValueAmount) && empty($freeOnBoardValueAmount))) {
            unset($this->FreeOnBoardValueAmount);
        } else {
            $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        }
        return $this;
    }
    /**
     * Get GoodsItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGoodsItem|null
     */
    public function getGoodsItem()
    {
        return isset($this->GoodsItem) ? $this->GoodsItem : null;
    }
    /**
     * Set GoodsItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGoodsItem $goodsItem
     * @return \StructType\Shipment
     */
    public function setGoodsItem(\ArrayType\ArrayOfGoodsItem $goodsItem = null)
    {
        if (is_null($goodsItem) || (is_array($goodsItem) && empty($goodsItem))) {
            unset($this->GoodsItem);
        } else {
            $this->GoodsItem = $goodsItem;
        }
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getGrossVolumeMeasure()
    {
        return isset($this->GrossVolumeMeasure) ? $this->GrossVolumeMeasure : null;
    }
    /**
     * Set GrossVolumeMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $grossVolumeMeasure
     * @return \StructType\Shipment
     */
    public function setGrossVolumeMeasure(\StructType\Measure $grossVolumeMeasure = null)
    {
        if (is_null($grossVolumeMeasure) || (is_array($grossVolumeMeasure) && empty($grossVolumeMeasure))) {
            unset($this->GrossVolumeMeasure);
        } else {
            $this->GrossVolumeMeasure = $grossVolumeMeasure;
        }
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getGrossWeightMeasure()
    {
        return isset($this->GrossWeightMeasure) ? $this->GrossWeightMeasure : null;
    }
    /**
     * Set GrossWeightMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $grossWeightMeasure
     * @return \StructType\Shipment
     */
    public function setGrossWeightMeasure(\StructType\Measure $grossWeightMeasure = null)
    {
        if (is_null($grossWeightMeasure) || (is_array($grossWeightMeasure) && empty($grossWeightMeasure))) {
            unset($this->GrossWeightMeasure);
        } else {
            $this->GrossWeightMeasure = $grossWeightMeasure;
        }
        return $this;
    }
    /**
     * Get HandlingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandlingCode()
    {
        return isset($this->HandlingCode) ? $this->HandlingCode : null;
    }
    /**
     * Set HandlingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handlingCode
     * @return \StructType\Shipment
     */
    public function setHandlingCode($handlingCode = null)
    {
        // validation for constraint: string
        if (!is_null($handlingCode) && !is_string($handlingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingCode, true), gettype($handlingCode)), __LINE__);
        }
        if (is_null($handlingCode) || (is_array($handlingCode) && empty($handlingCode))) {
            unset($this->HandlingCode);
        } else {
            $this->HandlingCode = $handlingCode;
        }
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandlingInstructions()
    {
        return isset($this->HandlingInstructions) ? $this->HandlingInstructions : null;
    }
    /**
     * Set HandlingInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handlingInstructions
     * @return \StructType\Shipment
     */
    public function setHandlingInstructions($handlingInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($handlingInstructions) && !is_string($handlingInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingInstructions, true), gettype($handlingInstructions)), __LINE__);
        }
        if (is_null($handlingInstructions) || (is_array($handlingInstructions) && empty($handlingInstructions))) {
            unset($this->HandlingInstructions);
        } else {
            $this->HandlingInstructions = $handlingInstructions;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\Shipment
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getInsuranceValueAmount()
    {
        return isset($this->InsuranceValueAmount) ? $this->InsuranceValueAmount : null;
    }
    /**
     * Set InsuranceValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $insuranceValueAmount
     * @return \StructType\Shipment
     */
    public function setInsuranceValueAmount(\StructType\Amount $insuranceValueAmount = null)
    {
        if (is_null($insuranceValueAmount) || (is_array($insuranceValueAmount) && empty($insuranceValueAmount))) {
            unset($this->InsuranceValueAmount);
        } else {
            $this->InsuranceValueAmount = $insuranceValueAmount;
        }
        return $this;
    }
    /**
     * Get LastExitPortLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Location|null
     */
    public function getLastExitPortLocation()
    {
        return isset($this->LastExitPortLocation) ? $this->LastExitPortLocation : null;
    }
    /**
     * Set LastExitPortLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Location $lastExitPortLocation
     * @return \StructType\Shipment
     */
    public function setLastExitPortLocation(\StructType\Location $lastExitPortLocation = null)
    {
        if (is_null($lastExitPortLocation) || (is_array($lastExitPortLocation) && empty($lastExitPortLocation))) {
            unset($this->LastExitPortLocation);
        } else {
            $this->LastExitPortLocation = $lastExitPortLocation;
        }
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getNetVolumeMeasure()
    {
        return isset($this->NetVolumeMeasure) ? $this->NetVolumeMeasure : null;
    }
    /**
     * Set NetVolumeMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $netVolumeMeasure
     * @return \StructType\Shipment
     */
    public function setNetVolumeMeasure(\StructType\Measure $netVolumeMeasure = null)
    {
        if (is_null($netVolumeMeasure) || (is_array($netVolumeMeasure) && empty($netVolumeMeasure))) {
            unset($this->NetVolumeMeasure);
        } else {
            $this->NetVolumeMeasure = $netVolumeMeasure;
        }
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getNetWeightMeasure()
    {
        return isset($this->NetWeightMeasure) ? $this->NetWeightMeasure : null;
    }
    /**
     * Set NetWeightMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $netWeightMeasure
     * @return \StructType\Shipment
     */
    public function setNetWeightMeasure(\StructType\Measure $netWeightMeasure = null)
    {
        if (is_null($netWeightMeasure) || (is_array($netWeightMeasure) && empty($netWeightMeasure))) {
            unset($this->NetWeightMeasure);
        } else {
            $this->NetWeightMeasure = $netWeightMeasure;
        }
        return $this;
    }
    /**
     * Get ReturnAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getReturnAddress()
    {
        return isset($this->ReturnAddress) ? $this->ReturnAddress : null;
    }
    /**
     * Set ReturnAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $returnAddress
     * @return \StructType\Shipment
     */
    public function setReturnAddress(\StructType\Address $returnAddress = null)
    {
        if (is_null($returnAddress) || (is_array($returnAddress) && empty($returnAddress))) {
            unset($this->ReturnAddress);
        } else {
            $this->ReturnAddress = $returnAddress;
        }
        return $this;
    }
    /**
     * Get ShipmentStage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfShipmentStage|null
     */
    public function getShipmentStage()
    {
        return isset($this->ShipmentStage) ? $this->ShipmentStage : null;
    }
    /**
     * Set ShipmentStage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfShipmentStage $shipmentStage
     * @return \StructType\Shipment
     */
    public function setShipmentStage(\ArrayType\ArrayOfShipmentStage $shipmentStage = null)
    {
        if (is_null($shipmentStage) || (is_array($shipmentStage) && empty($shipmentStage))) {
            unset($this->ShipmentStage);
        } else {
            $this->ShipmentStage = $shipmentStage;
        }
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getSpecialInstructions()
    {
        return isset($this->SpecialInstructions) ? $this->SpecialInstructions : null;
    }
    /**
     * Set SpecialInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $specialInstructions
     * @return \StructType\Shipment
     */
    public function setSpecialInstructions(\ArrayType\ArrayOfstring $specialInstructions = null)
    {
        if (is_null($specialInstructions) || (is_array($specialInstructions) && empty($specialInstructions))) {
            unset($this->SpecialInstructions);
        } else {
            $this->SpecialInstructions = $specialInstructions;
        }
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return float|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param float $totalGoodsItemQuantity
     * @return \StructType\Shipment
     */
    public function setTotalGoodsItemQuantity($totalGoodsItemQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($totalGoodsItemQuantity) && !(is_float($totalGoodsItemQuantity) || is_numeric($totalGoodsItemQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalGoodsItemQuantity, true), gettype($totalGoodsItemQuantity)), __LINE__);
        }
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalTransportHandlingUnitQuantity value
     * @return float|null
     */
    public function getTotalTransportHandlingUnitQuantity()
    {
        return $this->TotalTransportHandlingUnitQuantity;
    }
    /**
     * Set TotalTransportHandlingUnitQuantity value
     * @param float $totalTransportHandlingUnitQuantity
     * @return \StructType\Shipment
     */
    public function setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($totalTransportHandlingUnitQuantity) && !(is_float($totalTransportHandlingUnitQuantity) || is_numeric($totalTransportHandlingUnitQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTransportHandlingUnitQuantity, true), gettype($totalTransportHandlingUnitQuantity)), __LINE__);
        }
        $this->TotalTransportHandlingUnitQuantity = $totalTransportHandlingUnitQuantity;
        return $this;
    }
    /**
     * Get TransportHandlingUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTransportHandlingUnit|null
     */
    public function getTransportHandlingUnit()
    {
        return isset($this->TransportHandlingUnit) ? $this->TransportHandlingUnit : null;
    }
    /**
     * Set TransportHandlingUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTransportHandlingUnit $transportHandlingUnit
     * @return \StructType\Shipment
     */
    public function setTransportHandlingUnit(\ArrayType\ArrayOfTransportHandlingUnit $transportHandlingUnit = null)
    {
        if (is_null($transportHandlingUnit) || (is_array($transportHandlingUnit) && empty($transportHandlingUnit))) {
            unset($this->TransportHandlingUnit);
        } else {
            $this->TransportHandlingUnit = $transportHandlingUnit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
