<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoicesRawRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SendInvoicesRawRequest
 * @subpackage Structs
 */
class SendInvoicesRawRequest extends RequestBase
{
    /**
     * The AcceptanceDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AcceptanceDateTime;
    /**
     * The Invoices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOutgoingInvoiceRaw
     */
    public $Invoices;
    /**
     * Constructor method for SendInvoicesRawRequest
     * @uses SendInvoicesRawRequest::setAcceptanceDateTime()
     * @uses SendInvoicesRawRequest::setInvoices()
     * @param string $acceptanceDateTime
     * @param \ArrayType\ArrayOfOutgoingInvoiceRaw $invoices
     */
    public function __construct($acceptanceDateTime = null, \ArrayType\ArrayOfOutgoingInvoiceRaw $invoices = null)
    {
        $this
            ->setAcceptanceDateTime($acceptanceDateTime)
            ->setInvoices($invoices);
    }
    /**
     * Get AcceptanceDateTime value
     * @return string|null
     */
    public function getAcceptanceDateTime()
    {
        return $this->AcceptanceDateTime;
    }
    /**
     * Set AcceptanceDateTime value
     * @param string $acceptanceDateTime
     * @return \StructType\SendInvoicesRawRequest
     */
    public function setAcceptanceDateTime($acceptanceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($acceptanceDateTime) && !is_string($acceptanceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptanceDateTime, true), gettype($acceptanceDateTime)), __LINE__);
        }
        $this->AcceptanceDateTime = $acceptanceDateTime;
        return $this;
    }
    /**
     * Get Invoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOutgoingInvoiceRaw|null
     */
    public function getInvoices()
    {
        return isset($this->Invoices) ? $this->Invoices : null;
    }
    /**
     * Set Invoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOutgoingInvoiceRaw $invoices
     * @return \StructType\SendInvoicesRawRequest
     */
    public function setInvoices(\ArrayType\ArrayOfOutgoingInvoiceRaw $invoices = null)
    {
        if (is_null($invoices) || (is_array($invoices) && empty($invoices))) {
            unset($this->Invoices);
        } else {
            $this->Invoices = $invoices;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendInvoicesRawRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
