<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadTransport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoadTransport
 * @subpackage Structs
 */
class RoadTransport extends AbstractStructBase
{
    /**
     * The LicensePlateID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LicensePlateID;
    /**
     * Constructor method for RoadTransport
     * @uses RoadTransport::setLicensePlateID()
     * @param string $licensePlateID
     */
    public function __construct($licensePlateID = null)
    {
        $this
            ->setLicensePlateID($licensePlateID);
    }
    /**
     * Get LicensePlateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLicensePlateID()
    {
        return isset($this->LicensePlateID) ? $this->LicensePlateID : null;
    }
    /**
     * Set LicensePlateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $licensePlateID
     * @return \StructType\RoadTransport
     */
    public function setLicensePlateID($licensePlateID = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlateID) && !is_string($licensePlateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlateID, true), gettype($licensePlateID)), __LINE__);
        }
        if (is_null($licensePlateID) || (is_array($licensePlateID) && empty($licensePlateID))) {
            unset($this->LicensePlateID);
        } else {
            $this->LicensePlateID = $licensePlateID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadTransport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
