<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestHeader
 * @subpackage Structs
 */
class RequestHeader extends AbstractStructBase
{
    /**
     * The InstitutionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InstitutionId;
    /**
     * The OriginatorUserId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginatorUserId;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for RequestHeader
     * @uses RequestHeader::setInstitutionId()
     * @uses RequestHeader::setOriginatorUserId()
     * @uses RequestHeader::setPassword()
     * @uses RequestHeader::setUsername()
     * @param int $institutionId
     * @param int $originatorUserId
     * @param string $password
     * @param string $username
     */
    public function __construct($institutionId = null, $originatorUserId = null, $password = null, $username = null)
    {
        $this
            ->setInstitutionId($institutionId)
            ->setOriginatorUserId($originatorUserId)
            ->setPassword($password)
            ->setUsername($username);
    }
    /**
     * Get InstitutionId value
     * @return int|null
     */
    public function getInstitutionId()
    {
        return $this->InstitutionId;
    }
    /**
     * Set InstitutionId value
     * @param int $institutionId
     * @return \StructType\RequestHeader
     */
    public function setInstitutionId($institutionId = null)
    {
        // validation for constraint: int
        if (!is_null($institutionId) && !(is_int($institutionId) || ctype_digit($institutionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($institutionId, true), gettype($institutionId)), __LINE__);
        }
        $this->InstitutionId = $institutionId;
        return $this;
    }
    /**
     * Get OriginatorUserId value
     * @return int|null
     */
    public function getOriginatorUserId()
    {
        return $this->OriginatorUserId;
    }
    /**
     * Set OriginatorUserId value
     * @param int $originatorUserId
     * @return \StructType\RequestHeader
     */
    public function setOriginatorUserId($originatorUserId = null)
    {
        // validation for constraint: int
        if (!is_null($originatorUserId) && !(is_int($originatorUserId) || ctype_digit($originatorUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originatorUserId, true), gettype($originatorUserId)), __LINE__);
        }
        $this->OriginatorUserId = $originatorUserId;
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\RequestHeader
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\RequestHeader
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
