<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestBase StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestBase
 * @subpackage Structs
 */
class RequestBase extends AbstractStructBase
{
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RequestHeader
     */
    public $Header;
    /**
     * Constructor method for RequestBase
     * @uses RequestBase::setHeader()
     * @param \StructType\RequestHeader $header
     */
    public function __construct(\StructType\RequestHeader $header = null)
    {
        $this
            ->setHeader($header);
    }
    /**
     * Get Header value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RequestHeader|null
     */
    public function getHeader()
    {
        return isset($this->Header) ? $this->Header : null;
    }
    /**
     * Set Header value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RequestHeader $header
     * @return \StructType\RequestBase
     */
    public function setHeader(\StructType\RequestHeader $header = null)
    {
        if (is_null($header) || (is_array($header) && empty($header))) {
            unset($this->Header);
        } else {
            $this->Header = $header;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
