<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplyInvoiceItem StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReplyInvoiceItem
 * @subpackage Structs
 */
class ReplyInvoiceItem extends AbstractStructBase
{
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The ReplyDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReplyDescription;
    /**
     * The ReplyState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReplyState;
    /**
     * Constructor method for ReplyInvoiceItem
     * @uses ReplyInvoiceItem::setReferenceNumber()
     * @uses ReplyInvoiceItem::setReplyDescription()
     * @uses ReplyInvoiceItem::setReplyState()
     * @param int $referenceNumber
     * @param string $replyDescription
     * @param int $replyState
     */
    public function __construct($referenceNumber = null, $replyDescription = null, $replyState = null)
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setReplyDescription($replyDescription)
            ->setReplyState($replyState);
    }
    /**
     * Get ReferenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\ReplyInvoiceItem
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ReplyDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplyDescription()
    {
        return isset($this->ReplyDescription) ? $this->ReplyDescription : null;
    }
    /**
     * Set ReplyDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replyDescription
     * @return \StructType\ReplyInvoiceItem
     */
    public function setReplyDescription($replyDescription = null)
    {
        // validation for constraint: string
        if (!is_null($replyDescription) && !is_string($replyDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyDescription, true), gettype($replyDescription)), __LINE__);
        }
        if (is_null($replyDescription) || (is_array($replyDescription) && empty($replyDescription))) {
            unset($this->ReplyDescription);
        } else {
            $this->ReplyDescription = $replyDescription;
        }
        return $this;
    }
    /**
     * Get ReplyState value
     * @return int|null
     */
    public function getReplyState()
    {
        return $this->ReplyState;
    }
    /**
     * Set ReplyState value
     * @param int $replyState
     * @return \StructType\ReplyInvoiceItem
     */
    public function setReplyState($replyState = null)
    {
        // validation for constraint: int
        if (!is_null($replyState) && !(is_int($replyState) || ctype_digit($replyState))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($replyState, true), gettype($replyState)), __LINE__);
        }
        $this->ReplyState = $replyState;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReplyInvoiceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
