<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepeatEArchiveSMSResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RepeatEArchiveSMSResponse
 * @subpackage Structs
 */
class RepeatEArchiveSMSResponse extends ResponseBase
{
    /**
     * The SmsDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SmsDescription;
    /**
     * The SmsStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SmsStatus;
    /**
     * The SmsStatusDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SmsStatusDescription;
    /**
     * Constructor method for RepeatEArchiveSMSResponse
     * @uses RepeatEArchiveSMSResponse::setSmsDescription()
     * @uses RepeatEArchiveSMSResponse::setSmsStatus()
     * @uses RepeatEArchiveSMSResponse::setSmsStatusDescription()
     * @param string $smsDescription
     * @param int $smsStatus
     * @param string $smsStatusDescription
     */
    public function __construct($smsDescription = null, $smsStatus = null, $smsStatusDescription = null)
    {
        $this
            ->setSmsDescription($smsDescription)
            ->setSmsStatus($smsStatus)
            ->setSmsStatusDescription($smsStatusDescription);
    }
    /**
     * Get SmsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmsDescription()
    {
        return isset($this->SmsDescription) ? $this->SmsDescription : null;
    }
    /**
     * Set SmsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smsDescription
     * @return \StructType\RepeatEArchiveSMSResponse
     */
    public function setSmsDescription($smsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($smsDescription) && !is_string($smsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsDescription, true), gettype($smsDescription)), __LINE__);
        }
        if (is_null($smsDescription) || (is_array($smsDescription) && empty($smsDescription))) {
            unset($this->SmsDescription);
        } else {
            $this->SmsDescription = $smsDescription;
        }
        return $this;
    }
    /**
     * Get SmsStatus value
     * @return int|null
     */
    public function getSmsStatus()
    {
        return $this->SmsStatus;
    }
    /**
     * Set SmsStatus value
     * @param int $smsStatus
     * @return \StructType\RepeatEArchiveSMSResponse
     */
    public function setSmsStatus($smsStatus = null)
    {
        // validation for constraint: int
        if (!is_null($smsStatus) && !(is_int($smsStatus) || ctype_digit($smsStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($smsStatus, true), gettype($smsStatus)), __LINE__);
        }
        $this->SmsStatus = $smsStatus;
        return $this;
    }
    /**
     * Get SmsStatusDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmsStatusDescription()
    {
        return isset($this->SmsStatusDescription) ? $this->SmsStatusDescription : null;
    }
    /**
     * Set SmsStatusDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smsStatusDescription
     * @return \StructType\RepeatEArchiveSMSResponse
     */
    public function setSmsStatusDescription($smsStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($smsStatusDescription) && !is_string($smsStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsStatusDescription, true), gettype($smsStatusDescription)), __LINE__);
        }
        if (is_null($smsStatusDescription) || (is_array($smsStatusDescription) && empty($smsStatusDescription))) {
            unset($this->SmsStatusDescription);
        } else {
            $this->SmsStatusDescription = $smsStatusDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RepeatEArchiveSMSResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
