<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReconciliationInquiryResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReconciliationInquiryResponse
 * @subpackage Structs
 */
class ReconciliationInquiryResponse extends ResponseBase
{
    /**
     * The ArchieveInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ArchieveInvoiceCount;
    /**
     * The DeliveredInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeliveredInvoiceCount;
    /**
     * The ReceivedInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReceivedInvoiceCount;
    /**
     * The ReceivedInvoiceReplyCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReceivedInvoiceReplyCount;
    /**
     * The ReconciliationInquiryResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReconciliationInquiryResponse
     */
    public $ReconciliationInquiryResult;
    /**
     * Constructor method for ReconciliationInquiryResponse
     * @uses ReconciliationInquiryResponse::setArchieveInvoiceCount()
     * @uses ReconciliationInquiryResponse::setDeliveredInvoiceCount()
     * @uses ReconciliationInquiryResponse::setReceivedInvoiceCount()
     * @uses ReconciliationInquiryResponse::setReceivedInvoiceReplyCount()
     * @uses ReconciliationInquiryResponse::setReconciliationInquiryResult()
     * @param int $archieveInvoiceCount
     * @param int $deliveredInvoiceCount
     * @param int $receivedInvoiceCount
     * @param int $receivedInvoiceReplyCount
     * @param \StructType\ReconciliationInquiryResponse $reconciliationInquiryResult
     */
    public function __construct($archieveInvoiceCount = null, $deliveredInvoiceCount = null, $receivedInvoiceCount = null, $receivedInvoiceReplyCount = null, \StructType\ReconciliationInquiryResponse $reconciliationInquiryResult = null)
    {
        $this
            ->setArchieveInvoiceCount($archieveInvoiceCount)
            ->setDeliveredInvoiceCount($deliveredInvoiceCount)
            ->setReceivedInvoiceCount($receivedInvoiceCount)
            ->setReceivedInvoiceReplyCount($receivedInvoiceReplyCount)
            ->setReconciliationInquiryResult($reconciliationInquiryResult);
    }
    /**
     * Get ArchieveInvoiceCount value
     * @return int|null
     */
    public function getArchieveInvoiceCount()
    {
        return $this->ArchieveInvoiceCount;
    }
    /**
     * Set ArchieveInvoiceCount value
     * @param int $archieveInvoiceCount
     * @return \StructType\ReconciliationInquiryResponse
     */
    public function setArchieveInvoiceCount($archieveInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($archieveInvoiceCount) && !(is_int($archieveInvoiceCount) || ctype_digit($archieveInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($archieveInvoiceCount, true), gettype($archieveInvoiceCount)), __LINE__);
        }
        $this->ArchieveInvoiceCount = $archieveInvoiceCount;
        return $this;
    }
    /**
     * Get DeliveredInvoiceCount value
     * @return int|null
     */
    public function getDeliveredInvoiceCount()
    {
        return $this->DeliveredInvoiceCount;
    }
    /**
     * Set DeliveredInvoiceCount value
     * @param int $deliveredInvoiceCount
     * @return \StructType\ReconciliationInquiryResponse
     */
    public function setDeliveredInvoiceCount($deliveredInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($deliveredInvoiceCount) && !(is_int($deliveredInvoiceCount) || ctype_digit($deliveredInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveredInvoiceCount, true), gettype($deliveredInvoiceCount)), __LINE__);
        }
        $this->DeliveredInvoiceCount = $deliveredInvoiceCount;
        return $this;
    }
    /**
     * Get ReceivedInvoiceCount value
     * @return int|null
     */
    public function getReceivedInvoiceCount()
    {
        return $this->ReceivedInvoiceCount;
    }
    /**
     * Set ReceivedInvoiceCount value
     * @param int $receivedInvoiceCount
     * @return \StructType\ReconciliationInquiryResponse
     */
    public function setReceivedInvoiceCount($receivedInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($receivedInvoiceCount) && !(is_int($receivedInvoiceCount) || ctype_digit($receivedInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receivedInvoiceCount, true), gettype($receivedInvoiceCount)), __LINE__);
        }
        $this->ReceivedInvoiceCount = $receivedInvoiceCount;
        return $this;
    }
    /**
     * Get ReceivedInvoiceReplyCount value
     * @return int|null
     */
    public function getReceivedInvoiceReplyCount()
    {
        return $this->ReceivedInvoiceReplyCount;
    }
    /**
     * Set ReceivedInvoiceReplyCount value
     * @param int $receivedInvoiceReplyCount
     * @return \StructType\ReconciliationInquiryResponse
     */
    public function setReceivedInvoiceReplyCount($receivedInvoiceReplyCount = null)
    {
        // validation for constraint: int
        if (!is_null($receivedInvoiceReplyCount) && !(is_int($receivedInvoiceReplyCount) || ctype_digit($receivedInvoiceReplyCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receivedInvoiceReplyCount, true), gettype($receivedInvoiceReplyCount)), __LINE__);
        }
        $this->ReceivedInvoiceReplyCount = $receivedInvoiceReplyCount;
        return $this;
    }
    /**
     * Get ReconciliationInquiryResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReconciliationInquiryResponse|null
     */
    public function getReconciliationInquiryResult()
    {
        return isset($this->ReconciliationInquiryResult) ? $this->ReconciliationInquiryResult : null;
    }
    /**
     * Set ReconciliationInquiryResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReconciliationInquiryResponse $reconciliationInquiryResult
     * @return \StructType\ReconciliationInquiryResponse
     */
    public function setReconciliationInquiryResult(\StructType\ReconciliationInquiryResponse $reconciliationInquiryResult = null)
    {
        if (is_null($reconciliationInquiryResult) || (is_array($reconciliationInquiryResult) && empty($reconciliationInquiryResult))) {
            unset($this->ReconciliationInquiryResult);
        } else {
            $this->ReconciliationInquiryResult = $reconciliationInquiryResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReconciliationInquiryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
