<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReconciliationInquiryRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReconciliationInquiryRequest
 * @subpackage Structs
 */
class ReconciliationInquiryRequest extends RequestBase
{
    /**
     * The ArchieveInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ArchieveInvoiceCount;
    /**
     * The ReceivedInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReceivedInvoiceCount;
    /**
     * The ReconciliationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReconciliationDate;
    /**
     * The SentInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SentInvoiceCount;
    /**
     * The SentInvoiceReplyCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SentInvoiceReplyCount;
    /**
     * Constructor method for ReconciliationInquiryRequest
     * @uses ReconciliationInquiryRequest::setArchieveInvoiceCount()
     * @uses ReconciliationInquiryRequest::setReceivedInvoiceCount()
     * @uses ReconciliationInquiryRequest::setReconciliationDate()
     * @uses ReconciliationInquiryRequest::setSentInvoiceCount()
     * @uses ReconciliationInquiryRequest::setSentInvoiceReplyCount()
     * @param int $archieveInvoiceCount
     * @param int $receivedInvoiceCount
     * @param string $reconciliationDate
     * @param int $sentInvoiceCount
     * @param int $sentInvoiceReplyCount
     */
    public function __construct($archieveInvoiceCount = null, $receivedInvoiceCount = null, $reconciliationDate = null, $sentInvoiceCount = null, $sentInvoiceReplyCount = null)
    {
        $this
            ->setArchieveInvoiceCount($archieveInvoiceCount)
            ->setReceivedInvoiceCount($receivedInvoiceCount)
            ->setReconciliationDate($reconciliationDate)
            ->setSentInvoiceCount($sentInvoiceCount)
            ->setSentInvoiceReplyCount($sentInvoiceReplyCount);
    }
    /**
     * Get ArchieveInvoiceCount value
     * @return int|null
     */
    public function getArchieveInvoiceCount()
    {
        return $this->ArchieveInvoiceCount;
    }
    /**
     * Set ArchieveInvoiceCount value
     * @param int $archieveInvoiceCount
     * @return \StructType\ReconciliationInquiryRequest
     */
    public function setArchieveInvoiceCount($archieveInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($archieveInvoiceCount) && !(is_int($archieveInvoiceCount) || ctype_digit($archieveInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($archieveInvoiceCount, true), gettype($archieveInvoiceCount)), __LINE__);
        }
        $this->ArchieveInvoiceCount = $archieveInvoiceCount;
        return $this;
    }
    /**
     * Get ReceivedInvoiceCount value
     * @return int|null
     */
    public function getReceivedInvoiceCount()
    {
        return $this->ReceivedInvoiceCount;
    }
    /**
     * Set ReceivedInvoiceCount value
     * @param int $receivedInvoiceCount
     * @return \StructType\ReconciliationInquiryRequest
     */
    public function setReceivedInvoiceCount($receivedInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($receivedInvoiceCount) && !(is_int($receivedInvoiceCount) || ctype_digit($receivedInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receivedInvoiceCount, true), gettype($receivedInvoiceCount)), __LINE__);
        }
        $this->ReceivedInvoiceCount = $receivedInvoiceCount;
        return $this;
    }
    /**
     * Get ReconciliationDate value
     * @return string|null
     */
    public function getReconciliationDate()
    {
        return $this->ReconciliationDate;
    }
    /**
     * Set ReconciliationDate value
     * @param string $reconciliationDate
     * @return \StructType\ReconciliationInquiryRequest
     */
    public function setReconciliationDate($reconciliationDate = null)
    {
        // validation for constraint: string
        if (!is_null($reconciliationDate) && !is_string($reconciliationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reconciliationDate, true), gettype($reconciliationDate)), __LINE__);
        }
        $this->ReconciliationDate = $reconciliationDate;
        return $this;
    }
    /**
     * Get SentInvoiceCount value
     * @return int|null
     */
    public function getSentInvoiceCount()
    {
        return $this->SentInvoiceCount;
    }
    /**
     * Set SentInvoiceCount value
     * @param int $sentInvoiceCount
     * @return \StructType\ReconciliationInquiryRequest
     */
    public function setSentInvoiceCount($sentInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($sentInvoiceCount) && !(is_int($sentInvoiceCount) || ctype_digit($sentInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sentInvoiceCount, true), gettype($sentInvoiceCount)), __LINE__);
        }
        $this->SentInvoiceCount = $sentInvoiceCount;
        return $this;
    }
    /**
     * Get SentInvoiceReplyCount value
     * @return int|null
     */
    public function getSentInvoiceReplyCount()
    {
        return $this->SentInvoiceReplyCount;
    }
    /**
     * Set SentInvoiceReplyCount value
     * @param int $sentInvoiceReplyCount
     * @return \StructType\ReconciliationInquiryRequest
     */
    public function setSentInvoiceReplyCount($sentInvoiceReplyCount = null)
    {
        // validation for constraint: int
        if (!is_null($sentInvoiceReplyCount) && !(is_int($sentInvoiceReplyCount) || ctype_digit($sentInvoiceReplyCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sentInvoiceReplyCount, true), gettype($sentInvoiceReplyCount)), __LINE__);
        }
        $this->SentInvoiceReplyCount = $sentInvoiceReplyCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReconciliationInquiryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
