<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReconciliationDeliveryDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReconciliationDeliveryDetail
 * @subpackage Structs
 */
class ReconciliationDeliveryDetail extends AbstractStructBase
{
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Count;
    /**
     * The RequestNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestNumber;
    /**
     * Constructor method for ReconciliationDeliveryDetail
     * @uses ReconciliationDeliveryDetail::setCount()
     * @uses ReconciliationDeliveryDetail::setRequestNumber()
     * @param string $count
     * @param string $requestNumber
     */
    public function __construct($count = null, $requestNumber = null)
    {
        $this
            ->setCount($count)
            ->setRequestNumber($requestNumber);
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $count
     * @return \StructType\ReconciliationDeliveryDetail
     */
    public function setCount($count = null)
    {
        // validation for constraint: string
        if (!is_null($count) && !is_string($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get RequestNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestNumber()
    {
        return isset($this->RequestNumber) ? $this->RequestNumber : null;
    }
    /**
     * Set RequestNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestNumber
     * @return \StructType\ReconciliationDeliveryDetail
     */
    public function setRequestNumber($requestNumber = null)
    {
        // validation for constraint: string
        if (!is_null($requestNumber) && !is_string($requestNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestNumber, true), gettype($requestNumber)), __LINE__);
        }
        if (is_null($requestNumber) || (is_array($requestNumber) && empty($requestNumber))) {
            unset($this->RequestNumber);
        } else {
            $this->RequestNumber = $requestNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReconciliationDeliveryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
