<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiverAlias StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReceiverAlias
 * @subpackage Structs
 */
class ReceiverAlias extends AbstractStructBase
{
    /**
     * The Alias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Alias;
    /**
     * The AliasCreatedOn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AliasCreatedOn;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ReceiverAlias
     * @uses ReceiverAlias::setAlias()
     * @uses ReceiverAlias::setAliasCreatedOn()
     * @uses ReceiverAlias::setName()
     * @param string $alias
     * @param string $aliasCreatedOn
     * @param string $name
     */
    public function __construct($alias = null, $aliasCreatedOn = null, $name = null)
    {
        $this
            ->setAlias($alias)
            ->setAliasCreatedOn($aliasCreatedOn)
            ->setName($name);
    }
    /**
     * Get Alias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlias()
    {
        return isset($this->Alias) ? $this->Alias : null;
    }
    /**
     * Set Alias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alias
     * @return \StructType\ReceiverAlias
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        if (is_null($alias) || (is_array($alias) && empty($alias))) {
            unset($this->Alias);
        } else {
            $this->Alias = $alias;
        }
        return $this;
    }
    /**
     * Get AliasCreatedOn value
     * @return string|null
     */
    public function getAliasCreatedOn()
    {
        return $this->AliasCreatedOn;
    }
    /**
     * Set AliasCreatedOn value
     * @param string $aliasCreatedOn
     * @return \StructType\ReceiverAlias
     */
    public function setAliasCreatedOn($aliasCreatedOn = null)
    {
        // validation for constraint: string
        if (!is_null($aliasCreatedOn) && !is_string($aliasCreatedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasCreatedOn, true), gettype($aliasCreatedOn)), __LINE__);
        }
        $this->AliasCreatedOn = $aliasCreatedOn;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\ReceiverAlias
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReceiverAlias
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
