<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailTransport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RailTransport
 * @subpackage Structs
 */
class RailTransport extends AbstractStructBase
{
    /**
     * The RailCarID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RailCarID;
    /**
     * The TrainID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrainID;
    /**
     * Constructor method for RailTransport
     * @uses RailTransport::setRailCarID()
     * @uses RailTransport::setTrainID()
     * @param string $railCarID
     * @param string $trainID
     */
    public function __construct($railCarID = null, $trainID = null)
    {
        $this
            ->setRailCarID($railCarID)
            ->setTrainID($trainID);
    }
    /**
     * Get RailCarID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRailCarID()
    {
        return isset($this->RailCarID) ? $this->RailCarID : null;
    }
    /**
     * Set RailCarID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $railCarID
     * @return \StructType\RailTransport
     */
    public function setRailCarID($railCarID = null)
    {
        // validation for constraint: string
        if (!is_null($railCarID) && !is_string($railCarID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($railCarID, true), gettype($railCarID)), __LINE__);
        }
        if (is_null($railCarID) || (is_array($railCarID) && empty($railCarID))) {
            unset($this->RailCarID);
        } else {
            $this->RailCarID = $railCarID;
        }
        return $this;
    }
    /**
     * Get TrainID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrainID()
    {
        return isset($this->TrainID) ? $this->TrainID : null;
    }
    /**
     * Set TrainID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trainID
     * @return \StructType\RailTransport
     */
    public function setTrainID($trainID = null)
    {
        // validation for constraint: string
        if (!is_null($trainID) && !is_string($trainID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trainID, true), gettype($trainID)), __LINE__);
        }
        if (is_null($trainID) || (is_array($trainID) && empty($trainID))) {
            unset($this->TrainID);
        } else {
            $this->TrainID = $trainID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailTransport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
