<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PreviewInvoiceRequest
 * @subpackage Structs
 */
class PreviewInvoiceRequest extends RequestBase
{
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceToPreview
     */
    public $Invoice;
    /**
     * The ViewContentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ViewContentType;
    /**
     * Constructor method for PreviewInvoiceRequest
     * @uses PreviewInvoiceRequest::setInvoice()
     * @uses PreviewInvoiceRequest::setViewContentType()
     * @param \StructType\InvoiceToPreview $invoice
     * @param int $viewContentType
     */
    public function __construct(\StructType\InvoiceToPreview $invoice = null, $viewContentType = null)
    {
        $this
            ->setInvoice($invoice)
            ->setViewContentType($viewContentType);
    }
    /**
     * Get Invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceToPreview|null
     */
    public function getInvoice()
    {
        return isset($this->Invoice) ? $this->Invoice : null;
    }
    /**
     * Set Invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\InvoiceToPreview $invoice
     * @return \StructType\PreviewInvoiceRequest
     */
    public function setInvoice(\StructType\InvoiceToPreview $invoice = null)
    {
        if (is_null($invoice) || (is_array($invoice) && empty($invoice))) {
            unset($this->Invoice);
        } else {
            $this->Invoice = $invoice;
        }
        return $this;
    }
    /**
     * Get ViewContentType value
     * @return int|null
     */
    public function getViewContentType()
    {
        return $this->ViewContentType;
    }
    /**
     * Set ViewContentType value
     * @param int $viewContentType
     * @return \StructType\PreviewInvoiceRequest
     */
    public function setViewContentType($viewContentType = null)
    {
        // validation for constraint: int
        if (!is_null($viewContentType) && !(is_int($viewContentType) || ctype_digit($viewContentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewContentType, true), gettype($viewContentType)), __LINE__);
        }
        $this->ViewContentType = $viewContentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PreviewInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
