<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewInvoiceRawResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PreviewInvoiceRawResponse
 * @subpackage Structs
 */
class PreviewInvoiceRawResponse extends ResponseBase
{
    /**
     * The ViewContent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewContent;
    /**
     * The PreviewInvoiceRawResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PreviewInvoiceRawResponse
     */
    public $PreviewInvoiceRawResult;
    /**
     * Constructor method for PreviewInvoiceRawResponse
     * @uses PreviewInvoiceRawResponse::setViewContent()
     * @uses PreviewInvoiceRawResponse::setPreviewInvoiceRawResult()
     * @param string $viewContent
     * @param \StructType\PreviewInvoiceRawResponse $previewInvoiceRawResult
     */
    public function __construct($viewContent = null, \StructType\PreviewInvoiceRawResponse $previewInvoiceRawResult = null)
    {
        $this
            ->setViewContent($viewContent)
            ->setPreviewInvoiceRawResult($previewInvoiceRawResult);
    }
    /**
     * Get ViewContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewContent()
    {
        return isset($this->ViewContent) ? $this->ViewContent : null;
    }
    /**
     * Set ViewContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewContent
     * @return \StructType\PreviewInvoiceRawResponse
     */
    public function setViewContent($viewContent = null)
    {
        // validation for constraint: string
        if (!is_null($viewContent) && !is_string($viewContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewContent, true), gettype($viewContent)), __LINE__);
        }
        if (is_null($viewContent) || (is_array($viewContent) && empty($viewContent))) {
            unset($this->ViewContent);
        } else {
            $this->ViewContent = $viewContent;
        }
        return $this;
    }
    /**
     * Get PreviewInvoiceRawResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PreviewInvoiceRawResponse|null
     */
    public function getPreviewInvoiceRawResult()
    {
        return isset($this->PreviewInvoiceRawResult) ? $this->PreviewInvoiceRawResult : null;
    }
    /**
     * Set PreviewInvoiceRawResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PreviewInvoiceRawResponse $previewInvoiceRawResult
     * @return \StructType\PreviewInvoiceRawResponse
     */
    public function setPreviewInvoiceRawResult(\StructType\PreviewInvoiceRawResponse $previewInvoiceRawResult = null)
    {
        if (is_null($previewInvoiceRawResult) || (is_array($previewInvoiceRawResult) && empty($previewInvoiceRawResult))) {
            unset($this->PreviewInvoiceRawResult);
        } else {
            $this->PreviewInvoiceRawResult = $previewInvoiceRawResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PreviewInvoiceRawResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
