<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewInvoiceRawRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PreviewInvoiceRawRequest
 * @subpackage Structs
 */
class PreviewInvoiceRawRequest extends RequestBase
{
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Content;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The ViewContentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ViewContentType;
    /**
     * Constructor method for PreviewInvoiceRawRequest
     * @uses PreviewInvoiceRawRequest::setContent()
     * @uses PreviewInvoiceRawRequest::setInvoiceNumber()
     * @uses PreviewInvoiceRawRequest::setViewContentType()
     * @param string $content
     * @param string $invoiceNumber
     * @param int $viewContentType
     */
    public function __construct($content = null, $invoiceNumber = null, $viewContentType = null)
    {
        $this
            ->setContent($content)
            ->setInvoiceNumber($invoiceNumber)
            ->setViewContentType($viewContentType);
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $content
     * @return \StructType\PreviewInvoiceRawRequest
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceNumber
     * @return \StructType\PreviewInvoiceRawRequest
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get ViewContentType value
     * @return int|null
     */
    public function getViewContentType()
    {
        return $this->ViewContentType;
    }
    /**
     * Set ViewContentType value
     * @param int $viewContentType
     * @return \StructType\PreviewInvoiceRawRequest
     */
    public function setViewContentType($viewContentType = null)
    {
        // validation for constraint: int
        if (!is_null($viewContentType) && !(is_int($viewContentType) || ctype_digit($viewContentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewContentType, true), gettype($viewContentType)), __LINE__);
        }
        $this->ViewContentType = $viewContentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PreviewInvoiceRawRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
