<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Person
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The FamilyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FamilyName;
    /**
     * The FinancialAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FinancialAccount
     */
    public $FinancialAccount;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The IdentityDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentityDocumentReference
     */
    public $IdentityDocumentReference;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The NameSuffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameSuffix;
    /**
     * The NationalityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NationalityID;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * Constructor method for Person
     * @uses Person::setFamilyName()
     * @uses Person::setFinancialAccount()
     * @uses Person::setFirstName()
     * @uses Person::setIdentityDocumentReference()
     * @uses Person::setMiddleName()
     * @uses Person::setNameSuffix()
     * @uses Person::setNationalityID()
     * @uses Person::setTitle()
     * @param string $familyName
     * @param \StructType\FinancialAccount $financialAccount
     * @param string $firstName
     * @param \StructType\IdentityDocumentReference $identityDocumentReference
     * @param string $middleName
     * @param string $nameSuffix
     * @param string $nationalityID
     * @param string $title
     */
    public function __construct($familyName = null, \StructType\FinancialAccount $financialAccount = null, $firstName = null, \StructType\IdentityDocumentReference $identityDocumentReference = null, $middleName = null, $nameSuffix = null, $nationalityID = null, $title = null)
    {
        $this
            ->setFamilyName($familyName)
            ->setFinancialAccount($financialAccount)
            ->setFirstName($firstName)
            ->setIdentityDocumentReference($identityDocumentReference)
            ->setMiddleName($middleName)
            ->setNameSuffix($nameSuffix)
            ->setNationalityID($nationalityID)
            ->setTitle($title);
    }
    /**
     * Get FamilyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFamilyName()
    {
        return isset($this->FamilyName) ? $this->FamilyName : null;
    }
    /**
     * Set FamilyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $familyName
     * @return \StructType\Person
     */
    public function setFamilyName($familyName = null)
    {
        // validation for constraint: string
        if (!is_null($familyName) && !is_string($familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familyName, true), gettype($familyName)), __LINE__);
        }
        if (is_null($familyName) || (is_array($familyName) && empty($familyName))) {
            unset($this->FamilyName);
        } else {
            $this->FamilyName = $familyName;
        }
        return $this;
    }
    /**
     * Get FinancialAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FinancialAccount|null
     */
    public function getFinancialAccount()
    {
        return isset($this->FinancialAccount) ? $this->FinancialAccount : null;
    }
    /**
     * Set FinancialAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FinancialAccount $financialAccount
     * @return \StructType\Person
     */
    public function setFinancialAccount(\StructType\FinancialAccount $financialAccount = null)
    {
        if (is_null($financialAccount) || (is_array($financialAccount) && empty($financialAccount))) {
            unset($this->FinancialAccount);
        } else {
            $this->FinancialAccount = $financialAccount;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Person
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get IdentityDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentityDocumentReference|null
     */
    public function getIdentityDocumentReference()
    {
        return isset($this->IdentityDocumentReference) ? $this->IdentityDocumentReference : null;
    }
    /**
     * Set IdentityDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IdentityDocumentReference $identityDocumentReference
     * @return \StructType\Person
     */
    public function setIdentityDocumentReference(\StructType\IdentityDocumentReference $identityDocumentReference = null)
    {
        if (is_null($identityDocumentReference) || (is_array($identityDocumentReference) && empty($identityDocumentReference))) {
            unset($this->IdentityDocumentReference);
        } else {
            $this->IdentityDocumentReference = $identityDocumentReference;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \StructType\Person
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get NameSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameSuffix()
    {
        return isset($this->NameSuffix) ? $this->NameSuffix : null;
    }
    /**
     * Set NameSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameSuffix
     * @return \StructType\Person
     */
    public function setNameSuffix($nameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSuffix) && !is_string($nameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameSuffix, true), gettype($nameSuffix)), __LINE__);
        }
        if (is_null($nameSuffix) || (is_array($nameSuffix) && empty($nameSuffix))) {
            unset($this->NameSuffix);
        } else {
            $this->NameSuffix = $nameSuffix;
        }
        return $this;
    }
    /**
     * Get NationalityID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalityID()
    {
        return isset($this->NationalityID) ? $this->NationalityID : null;
    }
    /**
     * Set NationalityID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationalityID
     * @return \StructType\Person
     */
    public function setNationalityID($nationalityID = null)
    {
        // validation for constraint: string
        if (!is_null($nationalityID) && !is_string($nationalityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalityID, true), gettype($nationalityID)), __LINE__);
        }
        if (is_null($nationalityID) || (is_array($nationalityID) && empty($nationalityID))) {
            unset($this->NationalityID);
        } else {
            $this->NationalityID = $nationalityID;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\Person
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Person
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
