<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Period StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Period
 * @subpackage Structs
 */
class Period extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DurationMeasureCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurationMeasureCode;
    /**
     * The DurationMeasureValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurationMeasureValue;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDateTime;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDateTime;
    /**
     * Constructor method for Period
     * @uses Period::setDescription()
     * @uses Period::setDurationMeasureCode()
     * @uses Period::setDurationMeasureValue()
     * @uses Period::setEndDate()
     * @uses Period::setEndDateTime()
     * @uses Period::setStartDate()
     * @uses Period::setStartDateTime()
     * @param string $description
     * @param string $durationMeasureCode
     * @param string $durationMeasureValue
     * @param string $endDate
     * @param string $endDateTime
     * @param string $startDate
     * @param string $startDateTime
     */
    public function __construct($description = null, $durationMeasureCode = null, $durationMeasureValue = null, $endDate = null, $endDateTime = null, $startDate = null, $startDateTime = null)
    {
        $this
            ->setDescription($description)
            ->setDurationMeasureCode($durationMeasureCode)
            ->setDurationMeasureValue($durationMeasureValue)
            ->setEndDate($endDate)
            ->setEndDateTime($endDateTime)
            ->setStartDate($startDate)
            ->setStartDateTime($startDateTime);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Period
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DurationMeasureCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurationMeasureCode()
    {
        return isset($this->DurationMeasureCode) ? $this->DurationMeasureCode : null;
    }
    /**
     * Set DurationMeasureCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durationMeasureCode
     * @return \StructType\Period
     */
    public function setDurationMeasureCode($durationMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($durationMeasureCode) && !is_string($durationMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durationMeasureCode, true), gettype($durationMeasureCode)), __LINE__);
        }
        if (is_null($durationMeasureCode) || (is_array($durationMeasureCode) && empty($durationMeasureCode))) {
            unset($this->DurationMeasureCode);
        } else {
            $this->DurationMeasureCode = $durationMeasureCode;
        }
        return $this;
    }
    /**
     * Get DurationMeasureValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurationMeasureValue()
    {
        return isset($this->DurationMeasureValue) ? $this->DurationMeasureValue : null;
    }
    /**
     * Set DurationMeasureValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durationMeasureValue
     * @return \StructType\Period
     */
    public function setDurationMeasureValue($durationMeasureValue = null)
    {
        // validation for constraint: string
        if (!is_null($durationMeasureValue) && !is_string($durationMeasureValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durationMeasureValue, true), gettype($durationMeasureValue)), __LINE__);
        }
        if (is_null($durationMeasureValue) || (is_array($durationMeasureValue) && empty($durationMeasureValue))) {
            unset($this->DurationMeasureValue);
        } else {
            $this->DurationMeasureValue = $durationMeasureValue;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Period
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \StructType\Period
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateTime, true), gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Period
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \StructType\Period
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Period
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
