<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTerms StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentTerms
 * @subpackage Structs
 */
class PaymentTerms extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $Amount;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The PaymentDueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentDueDate;
    /**
     * The PenaltyAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $PenaltyAmount;
    /**
     * The PenaltySurchargePercent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PenaltySurchargePercent;
    /**
     * The SettlementPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Period
     */
    public $SettlementPeriod;
    /**
     * Constructor method for PaymentTerms
     * @uses PaymentTerms::setAmount()
     * @uses PaymentTerms::setNote()
     * @uses PaymentTerms::setPaymentDueDate()
     * @uses PaymentTerms::setPenaltyAmount()
     * @uses PaymentTerms::setPenaltySurchargePercent()
     * @uses PaymentTerms::setSettlementPeriod()
     * @param \StructType\Amount $amount
     * @param string $note
     * @param string $paymentDueDate
     * @param \StructType\Amount $penaltyAmount
     * @param float $penaltySurchargePercent
     * @param \StructType\Period $settlementPeriod
     */
    public function __construct(\StructType\Amount $amount = null, $note = null, $paymentDueDate = null, \StructType\Amount $penaltyAmount = null, $penaltySurchargePercent = null, \StructType\Period $settlementPeriod = null)
    {
        $this
            ->setAmount($amount)
            ->setNote($note)
            ->setPaymentDueDate($paymentDueDate)
            ->setPenaltyAmount($penaltyAmount)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setSettlementPeriod($settlementPeriod);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $amount
     * @return \StructType\PaymentTerms
     */
    public function setAmount(\StructType\Amount $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\PaymentTerms
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return string|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param string $paymentDueDate
     * @return \StructType\PaymentTerms
     */
    public function setPaymentDueDate($paymentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDueDate) && !is_string($paymentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDueDate, true), gettype($paymentDueDate)), __LINE__);
        }
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getPenaltyAmount()
    {
        return isset($this->PenaltyAmount) ? $this->PenaltyAmount : null;
    }
    /**
     * Set PenaltyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $penaltyAmount
     * @return \StructType\PaymentTerms
     */
    public function setPenaltyAmount(\StructType\Amount $penaltyAmount = null)
    {
        if (is_null($penaltyAmount) || (is_array($penaltyAmount) && empty($penaltyAmount))) {
            unset($this->PenaltyAmount);
        } else {
            $this->PenaltyAmount = $penaltyAmount;
        }
        return $this;
    }
    /**
     * Get PenaltySurchargePercent value
     * @return float|null
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }
    /**
     * Set PenaltySurchargePercent value
     * @param float $penaltySurchargePercent
     * @return \StructType\PaymentTerms
     */
    public function setPenaltySurchargePercent($penaltySurchargePercent = null)
    {
        // validation for constraint: float
        if (!is_null($penaltySurchargePercent) && !(is_float($penaltySurchargePercent) || is_numeric($penaltySurchargePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltySurchargePercent, true), gettype($penaltySurchargePercent)), __LINE__);
        }
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }
    /**
     * Get SettlementPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Period|null
     */
    public function getSettlementPeriod()
    {
        return isset($this->SettlementPeriod) ? $this->SettlementPeriod : null;
    }
    /**
     * Set SettlementPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Period $settlementPeriod
     * @return \StructType\PaymentTerms
     */
    public function setSettlementPeriod(\StructType\Period $settlementPeriod = null)
    {
        if (is_null($settlementPeriod) || (is_array($settlementPeriod) && empty($settlementPeriod))) {
            unset($this->SettlementPeriod);
        } else {
            $this->SettlementPeriod = $settlementPeriod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentTerms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
