<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRecorderInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentRecorderInfo
 * @subpackage Structs
 */
class PaymentRecorderInfo extends AbstractStructBase
{
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerialNumber;
    /**
     * The SlipDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SlipDate;
    /**
     * The SlipNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SlipNo;
    /**
     * The ZNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZNo;
    /**
     * Constructor method for PaymentRecorderInfo
     * @uses PaymentRecorderInfo::setSerialNumber()
     * @uses PaymentRecorderInfo::setSlipDate()
     * @uses PaymentRecorderInfo::setSlipNo()
     * @uses PaymentRecorderInfo::setZNo()
     * @param string $serialNumber
     * @param string $slipDate
     * @param string $slipNo
     * @param string $zNo
     */
    public function __construct($serialNumber = null, $slipDate = null, $slipNo = null, $zNo = null)
    {
        $this
            ->setSerialNumber($serialNumber)
            ->setSlipDate($slipDate)
            ->setSlipNo($slipNo)
            ->setZNo($zNo);
    }
    /**
     * Get SerialNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerialNumber()
    {
        return isset($this->SerialNumber) ? $this->SerialNumber : null;
    }
    /**
     * Set SerialNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serialNumber
     * @return \StructType\PaymentRecorderInfo
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        if (is_null($serialNumber) || (is_array($serialNumber) && empty($serialNumber))) {
            unset($this->SerialNumber);
        } else {
            $this->SerialNumber = $serialNumber;
        }
        return $this;
    }
    /**
     * Get SlipDate value
     * @return string|null
     */
    public function getSlipDate()
    {
        return $this->SlipDate;
    }
    /**
     * Set SlipDate value
     * @param string $slipDate
     * @return \StructType\PaymentRecorderInfo
     */
    public function setSlipDate($slipDate = null)
    {
        // validation for constraint: string
        if (!is_null($slipDate) && !is_string($slipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($slipDate, true), gettype($slipDate)), __LINE__);
        }
        $this->SlipDate = $slipDate;
        return $this;
    }
    /**
     * Get SlipNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSlipNo()
    {
        return isset($this->SlipNo) ? $this->SlipNo : null;
    }
    /**
     * Set SlipNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $slipNo
     * @return \StructType\PaymentRecorderInfo
     */
    public function setSlipNo($slipNo = null)
    {
        // validation for constraint: string
        if (!is_null($slipNo) && !is_string($slipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($slipNo, true), gettype($slipNo)), __LINE__);
        }
        if (is_null($slipNo) || (is_array($slipNo) && empty($slipNo))) {
            unset($this->SlipNo);
        } else {
            $this->SlipNo = $slipNo;
        }
        return $this;
    }
    /**
     * Get ZNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZNo()
    {
        return isset($this->ZNo) ? $this->ZNo : null;
    }
    /**
     * Set ZNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zNo
     * @return \StructType\PaymentRecorderInfo
     */
    public function setZNo($zNo = null)
    {
        // validation for constraint: string
        if (!is_null($zNo) && !is_string($zNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zNo, true), gettype($zNo)), __LINE__);
        }
        if (is_null($zNo) || (is_array($zNo) && empty($zNo))) {
            unset($this->ZNo);
        } else {
            $this->ZNo = $zNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentRecorderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
