<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeans StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentMeans
 * @subpackage Structs
 */
class PaymentMeans extends AbstractStructBase
{
    /**
     * The InstructionNote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstructionNote;
    /**
     * The PayeeFinancialAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FinancialAccount
     */
    public $PayeeFinancialAccount;
    /**
     * The PayerFinancialAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FinancialAccount
     */
    public $PayerFinancialAccount;
    /**
     * The PaymentChannelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentChannelCode;
    /**
     * The PaymentDueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentDueDate;
    /**
     * The PaymentMeansCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMeansCode;
    /**
     * Constructor method for PaymentMeans
     * @uses PaymentMeans::setInstructionNote()
     * @uses PaymentMeans::setPayeeFinancialAccount()
     * @uses PaymentMeans::setPayerFinancialAccount()
     * @uses PaymentMeans::setPaymentChannelCode()
     * @uses PaymentMeans::setPaymentDueDate()
     * @uses PaymentMeans::setPaymentMeansCode()
     * @param string $instructionNote
     * @param \StructType\FinancialAccount $payeeFinancialAccount
     * @param \StructType\FinancialAccount $payerFinancialAccount
     * @param string $paymentChannelCode
     * @param string $paymentDueDate
     * @param string $paymentMeansCode
     */
    public function __construct($instructionNote = null, \StructType\FinancialAccount $payeeFinancialAccount = null, \StructType\FinancialAccount $payerFinancialAccount = null, $paymentChannelCode = null, $paymentDueDate = null, $paymentMeansCode = null)
    {
        $this
            ->setInstructionNote($instructionNote)
            ->setPayeeFinancialAccount($payeeFinancialAccount)
            ->setPayerFinancialAccount($payerFinancialAccount)
            ->setPaymentChannelCode($paymentChannelCode)
            ->setPaymentDueDate($paymentDueDate)
            ->setPaymentMeansCode($paymentMeansCode);
    }
    /**
     * Get InstructionNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstructionNote()
    {
        return isset($this->InstructionNote) ? $this->InstructionNote : null;
    }
    /**
     * Set InstructionNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instructionNote
     * @return \StructType\PaymentMeans
     */
    public function setInstructionNote($instructionNote = null)
    {
        // validation for constraint: string
        if (!is_null($instructionNote) && !is_string($instructionNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructionNote, true), gettype($instructionNote)), __LINE__);
        }
        if (is_null($instructionNote) || (is_array($instructionNote) && empty($instructionNote))) {
            unset($this->InstructionNote);
        } else {
            $this->InstructionNote = $instructionNote;
        }
        return $this;
    }
    /**
     * Get PayeeFinancialAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FinancialAccount|null
     */
    public function getPayeeFinancialAccount()
    {
        return isset($this->PayeeFinancialAccount) ? $this->PayeeFinancialAccount : null;
    }
    /**
     * Set PayeeFinancialAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FinancialAccount $payeeFinancialAccount
     * @return \StructType\PaymentMeans
     */
    public function setPayeeFinancialAccount(\StructType\FinancialAccount $payeeFinancialAccount = null)
    {
        if (is_null($payeeFinancialAccount) || (is_array($payeeFinancialAccount) && empty($payeeFinancialAccount))) {
            unset($this->PayeeFinancialAccount);
        } else {
            $this->PayeeFinancialAccount = $payeeFinancialAccount;
        }
        return $this;
    }
    /**
     * Get PayerFinancialAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FinancialAccount|null
     */
    public function getPayerFinancialAccount()
    {
        return isset($this->PayerFinancialAccount) ? $this->PayerFinancialAccount : null;
    }
    /**
     * Set PayerFinancialAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FinancialAccount $payerFinancialAccount
     * @return \StructType\PaymentMeans
     */
    public function setPayerFinancialAccount(\StructType\FinancialAccount $payerFinancialAccount = null)
    {
        if (is_null($payerFinancialAccount) || (is_array($payerFinancialAccount) && empty($payerFinancialAccount))) {
            unset($this->PayerFinancialAccount);
        } else {
            $this->PayerFinancialAccount = $payerFinancialAccount;
        }
        return $this;
    }
    /**
     * Get PaymentChannelCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentChannelCode()
    {
        return isset($this->PaymentChannelCode) ? $this->PaymentChannelCode : null;
    }
    /**
     * Set PaymentChannelCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentChannelCode
     * @return \StructType\PaymentMeans
     */
    public function setPaymentChannelCode($paymentChannelCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentChannelCode) && !is_string($paymentChannelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentChannelCode, true), gettype($paymentChannelCode)), __LINE__);
        }
        if (is_null($paymentChannelCode) || (is_array($paymentChannelCode) && empty($paymentChannelCode))) {
            unset($this->PaymentChannelCode);
        } else {
            $this->PaymentChannelCode = $paymentChannelCode;
        }
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return string|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param string $paymentDueDate
     * @return \StructType\PaymentMeans
     */
    public function setPaymentDueDate($paymentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDueDate) && !is_string($paymentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDueDate, true), gettype($paymentDueDate)), __LINE__);
        }
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get PaymentMeansCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMeansCode()
    {
        return isset($this->PaymentMeansCode) ? $this->PaymentMeansCode : null;
    }
    /**
     * Set PaymentMeansCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMeansCode
     * @return \StructType\PaymentMeans
     */
    public function setPaymentMeansCode($paymentMeansCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMeansCode) && !is_string($paymentMeansCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMeansCode, true), gettype($paymentMeansCode)), __LINE__);
        }
        if (is_null($paymentMeansCode) || (is_array($paymentMeansCode) && empty($paymentMeansCode))) {
            unset($this->PaymentMeansCode);
        } else {
            $this->PaymentMeansCode = $paymentMeansCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentMeans
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
