<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyLegalEntity StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PartyLegalEntity
 * @subpackage Structs
 */
class PartyLegalEntity extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyID;
    /**
     * The CorporateRegistrationScheme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CorporateRegistrationScheme
     */
    public $CorporateRegistrationScheme;
    /**
     * The CorporateStockAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $CorporateStockAmount;
    /**
     * The FullyPaidSharesIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $FullyPaidSharesIndicator;
    /**
     * The HeadParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HeadParty
     */
    public $HeadParty;
    /**
     * The RegistrationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationDate;
    /**
     * The RegistrationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationName;
    /**
     * The SoleProprietorshipIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SoleProprietorshipIndicator;
    /**
     * Constructor method for PartyLegalEntity
     * @uses PartyLegalEntity::setCompanyID()
     * @uses PartyLegalEntity::setCorporateRegistrationScheme()
     * @uses PartyLegalEntity::setCorporateStockAmount()
     * @uses PartyLegalEntity::setFullyPaidSharesIndicator()
     * @uses PartyLegalEntity::setHeadParty()
     * @uses PartyLegalEntity::setRegistrationDate()
     * @uses PartyLegalEntity::setRegistrationName()
     * @uses PartyLegalEntity::setSoleProprietorshipIndicator()
     * @param string $companyID
     * @param \StructType\CorporateRegistrationScheme $corporateRegistrationScheme
     * @param \StructType\Amount $corporateStockAmount
     * @param bool $fullyPaidSharesIndicator
     * @param \StructType\HeadParty $headParty
     * @param string $registrationDate
     * @param string $registrationName
     * @param bool $soleProprietorshipIndicator
     */
    public function __construct($companyID = null, \StructType\CorporateRegistrationScheme $corporateRegistrationScheme = null, \StructType\Amount $corporateStockAmount = null, $fullyPaidSharesIndicator = null, \StructType\HeadParty $headParty = null, $registrationDate = null, $registrationName = null, $soleProprietorshipIndicator = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setCorporateRegistrationScheme($corporateRegistrationScheme)
            ->setCorporateStockAmount($corporateStockAmount)
            ->setFullyPaidSharesIndicator($fullyPaidSharesIndicator)
            ->setHeadParty($headParty)
            ->setRegistrationDate($registrationDate)
            ->setRegistrationName($registrationName)
            ->setSoleProprietorshipIndicator($soleProprietorshipIndicator);
    }
    /**
     * Get CompanyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyID()
    {
        return isset($this->CompanyID) ? $this->CompanyID : null;
    }
    /**
     * Set CompanyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyID
     * @return \StructType\PartyLegalEntity
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: string
        if (!is_null($companyID) && !is_string($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        if (is_null($companyID) || (is_array($companyID) && empty($companyID))) {
            unset($this->CompanyID);
        } else {
            $this->CompanyID = $companyID;
        }
        return $this;
    }
    /**
     * Get CorporateRegistrationScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CorporateRegistrationScheme|null
     */
    public function getCorporateRegistrationScheme()
    {
        return isset($this->CorporateRegistrationScheme) ? $this->CorporateRegistrationScheme : null;
    }
    /**
     * Set CorporateRegistrationScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CorporateRegistrationScheme $corporateRegistrationScheme
     * @return \StructType\PartyLegalEntity
     */
    public function setCorporateRegistrationScheme(\StructType\CorporateRegistrationScheme $corporateRegistrationScheme = null)
    {
        if (is_null($corporateRegistrationScheme) || (is_array($corporateRegistrationScheme) && empty($corporateRegistrationScheme))) {
            unset($this->CorporateRegistrationScheme);
        } else {
            $this->CorporateRegistrationScheme = $corporateRegistrationScheme;
        }
        return $this;
    }
    /**
     * Get CorporateStockAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getCorporateStockAmount()
    {
        return isset($this->CorporateStockAmount) ? $this->CorporateStockAmount : null;
    }
    /**
     * Set CorporateStockAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $corporateStockAmount
     * @return \StructType\PartyLegalEntity
     */
    public function setCorporateStockAmount(\StructType\Amount $corporateStockAmount = null)
    {
        if (is_null($corporateStockAmount) || (is_array($corporateStockAmount) && empty($corporateStockAmount))) {
            unset($this->CorporateStockAmount);
        } else {
            $this->CorporateStockAmount = $corporateStockAmount;
        }
        return $this;
    }
    /**
     * Get FullyPaidSharesIndicator value
     * @return bool|null
     */
    public function getFullyPaidSharesIndicator()
    {
        return $this->FullyPaidSharesIndicator;
    }
    /**
     * Set FullyPaidSharesIndicator value
     * @param bool $fullyPaidSharesIndicator
     * @return \StructType\PartyLegalEntity
     */
    public function setFullyPaidSharesIndicator($fullyPaidSharesIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullyPaidSharesIndicator) && !is_bool($fullyPaidSharesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullyPaidSharesIndicator, true), gettype($fullyPaidSharesIndicator)), __LINE__);
        }
        $this->FullyPaidSharesIndicator = $fullyPaidSharesIndicator;
        return $this;
    }
    /**
     * Get HeadParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HeadParty|null
     */
    public function getHeadParty()
    {
        return isset($this->HeadParty) ? $this->HeadParty : null;
    }
    /**
     * Set HeadParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HeadParty $headParty
     * @return \StructType\PartyLegalEntity
     */
    public function setHeadParty(\StructType\HeadParty $headParty = null)
    {
        if (is_null($headParty) || (is_array($headParty) && empty($headParty))) {
            unset($this->HeadParty);
        } else {
            $this->HeadParty = $headParty;
        }
        return $this;
    }
    /**
     * Get RegistrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param string $registrationDate
     * @return \StructType\PartyLegalEntity
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get RegistrationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationName()
    {
        return isset($this->RegistrationName) ? $this->RegistrationName : null;
    }
    /**
     * Set RegistrationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrationName
     * @return \StructType\PartyLegalEntity
     */
    public function setRegistrationName($registrationName = null)
    {
        // validation for constraint: string
        if (!is_null($registrationName) && !is_string($registrationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationName, true), gettype($registrationName)), __LINE__);
        }
        if (is_null($registrationName) || (is_array($registrationName) && empty($registrationName))) {
            unset($this->RegistrationName);
        } else {
            $this->RegistrationName = $registrationName;
        }
        return $this;
    }
    /**
     * Get SoleProprietorshipIndicator value
     * @return bool|null
     */
    public function getSoleProprietorshipIndicator()
    {
        return $this->SoleProprietorshipIndicator;
    }
    /**
     * Set SoleProprietorshipIndicator value
     * @param bool $soleProprietorshipIndicator
     * @return \StructType\PartyLegalEntity
     */
    public function setSoleProprietorshipIndicator($soleProprietorshipIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($soleProprietorshipIndicator) && !is_bool($soleProprietorshipIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($soleProprietorshipIndicator, true), gettype($soleProprietorshipIndicator)), __LINE__);
        }
        $this->SoleProprietorshipIndicator = $soleProprietorshipIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartyLegalEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
